/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.util.I18n;
import com.elluminate.util.io.FileSysUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

class Filter
extends FileFilter {
    private I18n i18n = I18n.create((Object)this);
    private HashSet<String> suffixes = new HashSet();
    private String desc = null;

    public Filter(String prefix) {
        String slist = this.i18n.getStringLegacy(prefix + ".suffixes");
        StringTokenizer parser = new StringTokenizer(slist, ",");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            this.suffixes.add(token);
        }
        this.desc = this.i18n.getStringLegacy(prefix + ".description");
    }

    @Override
    public boolean accept(File f) {
        if (FileSysUtils.isTraversableDirectory((File)f)) {
            return true;
        }
        String suffix = FileSysUtils.getExtension((File)f);
        if (suffix == null) {
            return false;
        }
        suffix = suffix.toLowerCase(Locale.ENGLISH);
        return this.suffixes.contains(suffix);
    }

    @Override
    public String getDescription() {
        return this.desc;
    }
}

