/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.CreateRoomsAndSplitCommand;
import com.elluminate.groupware.breakout.module.BreakoutBean;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class CreateRoomsAndSplitCmd
extends AbstractCommand
implements CreateRoomsAndSplitCommand {
    private static final long serialVersionUID = 1L;
    private String baseRoomName = "";
    private int groupSize = 4;
    private boolean includeModerators = false;
    private Provider<BreakoutBean> beanProvider;
    private I18n i18n = I18n.create((Object)((Object)this));

    @Inject
    public void initBreakoutBeanProvider(Provider<BreakoutBean> bp) {
        this.beanProvider = bp;
    }

    public void setBaseRoomName(String s) {
        this.baseRoomName = s;
    }

    public void setGroupSize(int i) {
        this.groupSize = i;
    }

    public void setIncludeModerators(boolean b) {
        this.includeModerators = b;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.baseRoomName == null || this.baseRoomName.length() < 1) {
            throw new CommandParameterException("Base room name must not be empty", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMCMD_BADPARAMBASEROOMNAMENOTSET));
        }
        if (this.groupSize < 2) {
            throw new CommandParameterException("Group size must be 2 or more", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMSANDSPLITCMD_BADPARAMGROUPSIZETOOSMALL, new Object[]{String.valueOf(this.groupSize)}));
        }
        if (this.groupSize > 1000) {
            throw new CommandParameterException("Group size must be 1000 or less", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMSANDSPLITCMD_BADPARAMGROUPSIZETOOLARGE, new Object[]{String.valueOf(this.groupSize)}));
        }
        BreakoutBean bean = (BreakoutBean)this.beanProvider.get();
        bean.distNPeople(this.groupSize, this.baseRoomName, this.includeModerators);
    }
}

