/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.CreateRoomsAndDistributeCommand;
import com.elluminate.groupware.breakout.module.BreakoutBean;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class CreateRoomsAndDistributeCmd
extends AbstractCommand
implements CreateRoomsAndDistributeCommand {
    private static final long serialVersionUID = 1L;
    private String baseRoomName = "";
    private int roomCount = 4;
    private boolean includeModerators = false;
    private Provider<BreakoutBean> beanProvider;
    private I18n i18n = I18n.create((Object)((Object)this));

    @Inject
    public void initBreakoutBeanProvider(Provider<BreakoutBean> bp) {
        this.beanProvider = bp;
    }

    public void setBaseRoomName(String s) {
        this.baseRoomName = s;
    }

    public void setRoomCount(int i) {
        this.roomCount = i;
    }

    public void setIncludeModerators(boolean b) {
        this.includeModerators = b;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.baseRoomName == null || this.baseRoomName.length() < 1) {
            throw new CommandParameterException("Base room name must not be empty", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMCMD_BADPARAMBASEROOMNAMENOTSET));
        }
        if (this.roomCount < 2) {
            throw new CommandParameterException("Room Count must be 2 or more", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMSANDDISTRIBUTECMD_BADPARAMROOMCOUNTTOOSMALL, new Object[]{String.valueOf(this.roomCount)}));
        }
        if (this.roomCount > 1000) {
            throw new CommandParameterException("Room Count must be 1000 or less", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMSANDDISTRIBUTECMD_BADPARAMROOMCOUNTTOOLARGE, new Object[]{String.valueOf(this.roomCount)}));
        }
        BreakoutBean bean = (BreakoutBean)this.beanProvider.get();
        bean.distNGroups(this.roomCount, this.baseRoomName, this.includeModerators);
    }
}

