/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.CreateRoomCommand;
import com.elluminate.groupware.breakout.module.BreakoutBean;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class CreateRoomCmd
extends AbstractCommand
implements CreateRoomCommand {
    private static final long serialVersionUID = 1L;
    private String roomName = null;
    private Provider<BreakoutBean> beanProvider;
    private I18n i18n = I18n.create((Object)((Object)this));

    @Inject
    public void initBreakoutBeanProvider(Provider<BreakoutBean> bp) {
        this.beanProvider = bp;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        BreakoutBean bean = (BreakoutBean)this.beanProvider.get();
        if (this.roomName == null || this.roomName.length() < 1) {
            throw new CommandParameterException("Room name must be at least 1 character long", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMCMD_BADPARAMROOMNAMENOTSET));
        }
        if (bean.isRoomNameExist(this.roomName)) {
            throw new CommandContextException("A room with this name already exists", this.i18n.getString((PropertiesEnum)StringsProperties.CREATEROOMCMD_BADCONTEXTROOMALREADYEXISTS, new Object[]{this.roomName}));
        }
        bean.create(this.roomName, new ClientInfo[0], false);
    }
}

