/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.breakout.BreakoutProtocol;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;

@Singleton
public class BreakoutBean
implements ChannelDataListener {
    private static String WHITESPACE = "      ";
    private final I18n i18n = I18n.create((Object)this);
    private DialogParentProvider parentProv;
    private ClientList clients;
    private JinxTerminal terminal = null;
    private Imps imps;
    TelephonyAPI telephonyApi = null;

    @Inject
    public BreakoutBean() {
    }

    @Inject
    public void initJinxTerminal(JinxTerminal terminal) {
        this.terminal = terminal;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initParentProv(DialogParentProvider prov) {
        this.parentProv = prov;
    }

    public void setClient(Client theClient) {
        BreakoutProtocol proto = new BreakoutProtocol();
        this.terminal.setProtocol((JinxProtocol)proto);
        this.terminal.createChannels(null, (ChannelDataListener)this);
        this.clients = theClient == null ? null : theClient.getClientList();
    }

    public void onChannelData(ChannelDataEvent e) {
        if (e.getSourceAddress() != 0) {
            return;
        }
        switch (e.getCommand()) {
            case -1: {
                try {
                    DataInputStream str = e.read();
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProv.getDialogParent(), (Object)BreakoutProtocol.getErrorMsg((DataInputStream)str, (ClientList)this.clients), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_ERRORTITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Group")}), (int)0);
                    str.close();
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
                }
                break;
            }
        }
    }

    public void create(String name, ClientInfo[] who, boolean temp) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean create");
        }
        if (name == null) {
            name = this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_PRIVATEROOMNAME);
        }
        if (this.isRoomNameExist(name)) {
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_DUPLICATEROOMMSG, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group"), name}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_DUPLICATEROOMTITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group")}), (int)0);
            return;
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
        DataOutputStream str = msg.write();
        try {
            str.writeUTF(name);
            str.writeBoolean(temp);
            str.writeShort(who.length);
            for (int i = 0; i < who.length; ++i) {
                str.writeShort(who[i].getAddress());
            }
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"create", (Throwable)ex, (boolean)true);
            try {
                str.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            msg.dispose();
            return;
        }
        this.terminal.getChannel().onChannelData(msg);
    }

    public void delete(ClientGroup[] grp) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean delete");
        }
        for (int i = 0; i < grp.length; ++i) {
            ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
            DataOutputStream str = msg.write();
            try {
                str.writeShort(grp[i].getGroupID());
                str.close();
            }
            catch (IOException ex) {
                try {
                    str.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                msg.dispose();
                return;
            }
            this.terminal.getChannel().onChannelData(msg);
        }
    }

    public void join(ClientGroup grp, ClientInfo[] who) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean join");
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)3);
        DataOutputStream str = msg.write();
        try {
            str.writeShort(grp.getGroupID());
            str.writeShort(who.length);
            for (int i = 0; i < who.length; ++i) {
                str.writeShort(who[i].getAddress());
            }
            str.close();
        }
        catch (IOException ex) {
            try {
                str.close();
            }
            catch (IOException iox) {
                // empty catch block
            }
            msg.dispose();
            return;
        }
        this.terminal.getChannel().onChannelData(msg);
    }

    public void rename(ClientGroup grp, String name) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean rename");
        }
        if (grp.getGroupID() == 0) {
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_RENAMEMAINMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_RENAMEMAINTITLE), (int)0);
            return;
        }
        if (this.isRoomNameExist(name)) {
            String label = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group");
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_DUPLICATEROOMMSG, new Object[]{label, name}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTBEAN_DUPLICATEROOMTITLE, new Object[]{label}), (int)0);
            return;
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)4);
        DataOutputStream str = msg.write();
        try {
            str.writeShort(grp.getGroupID());
            str.writeUTF(name);
            str.close();
        }
        catch (IOException iox) {
            try {
                str.close();
            }
            catch (IOException iox2) {
                // empty catch block
            }
            msg.dispose();
            return;
        }
        this.terminal.getChannel().onChannelData(msg);
    }

    public void rejoin() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean rejoin");
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)16);
        this.terminal.getChannel().onChannelData(msg);
    }

    public void redist(boolean mod) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean redist");
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)17);
        try {
            DataOutputStream ostr = msg.write();
            ostr.writeBoolean(mod);
            ostr.close();
        }
        catch (IOException iox) {
            LogSupport.exception((Object)this, (String)"redist", (Throwable)iox, (boolean)true);
            return;
        }
        this.terminal.getChannel().onChannelData(msg);
    }

    public boolean isRoomNameExist(String name) {
        Iterator i = this.clients.groupIterator();
        while (i.hasNext()) {
            ClientGroup nextGrp = (ClientGroup)i.next();
            if (!name.equals(nextGrp.getName())) continue;
            return true;
        }
        return false;
    }

    ClientGroup getRoom(String name) {
        Iterator i = this.clients.groupIterator();
        while (i.hasNext()) {
            ClientGroup nextGrp = (ClientGroup)i.next();
            if (!name.equals(nextGrp.getName())) continue;
            return nextGrp;
        }
        return null;
    }

    public Object[] getAllRooms() {
        ArrayList<ClientGroup> list = new ArrayList<ClientGroup>();
        Iterator i = this.clients.groupIterator();
        while (i.hasNext()) {
            list.add((ClientGroup)i.next());
        }
        return list.toArray();
    }

    public boolean areAllClientsInMainRoom() {
        if (this.clients == null || this.clients.getClientGroup((short)0) == null) {
            return false;
        }
        return this.clients.getClientGroup((short)0).getVisibleSize() >= this.clients.getVisibleSize();
    }

    boolean distNGroups(int n, String nm, boolean mod) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean distNGroups");
        }
        HashMap<String, DistInfo> map = new HashMap<String, DistInfo>();
        ClientGroup main = this.clients.getClientGroup((short)0);
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        DistInfo[] list = new DistInfo[n];
        int idx = 0;
        int count = this.getCount(main, mod ? null : chair);
        int len = String.valueOf(n).length();
        Random rnd = new Random();
        if (main == null) {
            return true;
        }
        TelephonyAPI api = this.getTelephonyAPI();
        int telephonyCount = this.getTelephonyCount(main, null, api);
        int telephonyCountWithModerators = this.getTelephonyCount(main, mod ? null : chair, api);
        for (int i = 0; i < n; ++i) {
            String grpName = nm + " " + this.pad(i + 1, len);
            ClientGroup grp = this.clients.getClientGroup(grpName);
            list[i] = new DistInfo(grp, mod ? null : chair);
            count += list[i].count;
            map.put(grpName, list[i]);
        }
        TreeMap<Integer, ClientInfo> reorder = new TreeMap<Integer, ClientInfo>();
        int clientsPlacedInTelephoneRoom = 0;
        int lastBoCountPrePlace = list[n - 1].count;
        Iterator i = main.visibleIterator();
        while (i.hasNext()) {
            ClientInfo ci = (ClientInfo)i.next();
            if (api != null && api.getAudioMode(ci.getAddress()) != 1) {
                list[0].who.add(ci);
                if (api.getAudioMode(ci.getAddress()) != 2) continue;
                ++list[0].count;
                ++clientsPlacedInTelephoneRoom;
                continue;
            }
            if (!mod && chair.contains(ci.getAddress())) continue;
            Integer key = new Integer(rnd.nextInt());
            reorder.put(key, ci);
        }
        int row = 0;
        for (ClientInfo ci : reorder.values()) {
            while (list[idx].count > row) {
                if (++idx != n) continue;
                idx = 0;
                ++row;
            }
            list[idx].who.add(ci);
            ++list[idx].count;
            if (++idx != n) continue;
            idx = 0;
            ++row;
        }
        if (telephonyCount != telephonyCountWithModerators) {
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNMOVEDMODERATORS), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNTITLE), (int)2);
        }
        int numberOfRowsInTelephonyRoom = list[0].count;
        int numRowsLastRoom = list[n - 1].count;
        if (telephonyCount > 0 && numberOfRowsInTelephonyRoom > numRowsLastRoom + 1 && clientsPlacedInTelephoneRoom > numRowsLastRoom - lastBoCountPrePlace) {
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNUNEVENDISTRIBUTION), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNTITLE), (int)2);
        }
        return this.execute(map);
    }

    private String pad(int num, int len) {
        String disp = Integer.toString(num);
        return WHITESPACE.substring(0, len - disp.length()) + disp;
    }

    boolean distNPeople(int n, String nm, boolean mod) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean distNPeople");
        }
        ClientGroup main = this.clients.getClientGroup((short)0);
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        int nRooms = 0;
        int count = this.getCount(main, mod ? null : chair);
        TelephonyAPI api = this.getTelephonyAPI();
        int telephonyCount = this.getTelephonyCount(main, null, api);
        while (count > 0) {
            int sz;
            String grpName = nm + " " + ++nRooms;
            ClientGroup grp = this.clients.getClientGroup(grpName);
            if (nRooms == 1) {
                int tsz;
                if (grp == null) {
                    if (telephonyCount < n) {
                        count -= n;
                        continue;
                    }
                    count -= telephonyCount;
                    continue;
                }
                sz = this.getCount(grp, mod ? null : chair);
                int totalSize = sz + (tsz = this.getTelephonyCount(grp, mod ? null : chair, api)) + telephonyCount;
                if (totalSize >= n) {
                    count -= telephonyCount;
                    continue;
                }
                count -= n - (sz + tsz);
                continue;
            }
            if (grp == null) {
                count -= n;
                continue;
            }
            sz = this.getCount(grp, mod ? null : chair);
            if (sz >= n) continue;
            count -= n - sz;
        }
        if (nRooms > 0) {
            return this.distNGroups(nRooms, nm, mod);
        }
        return true;
    }

    private int getCount(ClientGroup grp, Chair chair) {
        if (chair == null) {
            return grp.getVisibleSize();
        }
        int count = 0;
        Iterator i = grp.visibleIterator();
        while (i.hasNext()) {
            ClientInfo ci = (ClientInfo)i.next();
            if (chair.contains(ci.getAddress())) continue;
            ++count;
        }
        return count;
    }

    private int getTelephonyCount(ClientGroup grp, Chair chair, TelephonyAPI api) {
        if (api == null) {
            return 0;
        }
        int count = 0;
        Iterator i = grp.visibleIterator();
        while (i.hasNext()) {
            ClientInfo ci = (ClientInfo)i.next();
            int audioMode = api.getAudioMode(ci.getAddress());
            if (audioMode != 2 || chair != null && chair.contains(ci.getAddress())) continue;
            ++count;
        }
        return count;
    }

    protected TelephonyAPI getTelephonyAPI() {
        if (this.telephonyApi == null) {
            this.telephonyApi = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        }
        return this.telephonyApi;
    }

    private boolean execute(HashMap map) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: bean execute");
        }
        ClientInfo[] template = new ClientInfo[]{};
        for (String nm : map.keySet()) {
            DistInfo info = (DistInfo)map.get(nm);
            ClientInfo[] who = info.who.toArray(template);
            if (info.grp == null) {
                this.create(nm, who, false);
                continue;
            }
            this.join(info.grp, who);
        }
        return true;
    }

    class DistInfo {
        public int count = 0;
        public ClientGroup grp = null;
        public ArrayList who = new ArrayList();

        public DistInfo(ClientGroup grp, Chair chair) {
            if (grp != null) {
                this.grp = grp;
                this.count = BreakoutBean.this.getCount(grp, chair);
            }
        }
    }
}

