/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.util.ShortList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UpdateQueue {
    public static final byte WAITING = 0;
    public static final byte CREATED = 1;
    public static final byte DELETED = 2;
    public static final byte CHANGED = 3;
    public static final byte INTERRUPT = 4;
    public static final byte TIMEOUT = 5;
    private Map<Short, Map<ProfileItemID, Waiter>> clients = new HashMap<Short, Map<ProfileItemID, Waiter>>();

    public byte waitFor(short client, ProfileItemID id) {
        return this.waitFor(client, id, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte waitFor(short client, ProfileItemID id, long timeout) {
        Waiter w = null;
        int result = 0;
        Short key = ShortList.get((short)client);
        Object object = this.clients;
        synchronized (object) {
            Map<ProfileItemID, Waiter> c = this.clients.get(key);
            if (c == null) {
                c = new HashMap<ProfileItemID, Waiter>();
                this.clients.put(key, c);
            }
            if ((w = c.get(id)) == null) {
                w = new Waiter();
                c.put(id, w);
            }
        }
        object = w;
        synchronized (object) {
            long limit = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
            while (result == 0) {
                try {
                    long delay = limit - System.currentTimeMillis();
                    if (delay <= 0L) {
                        result = 5;
                        continue;
                    }
                    w.wait(timeout);
                    if (w.result == 0) continue;
                    result = w.result;
                }
                catch (InterruptedException ix) {
                    result = 4;
                }
            }
        }
        return (byte)result;
    }

    public void update(short client) {
        this.setClientState(client, (byte)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(short client, ProfileItemID id) {
        Map<Short, Map<ProfileItemID, Waiter>> map = this.clients;
        synchronized (map) {
            Waiter w;
            Map<ProfileItemID, Waiter> c = this.clients.get(ShortList.get((short)client));
            if (c != null && (w = c.get(id)) != null) {
                Waiter waiter = w;
                synchronized (waiter) {
                    w.result = 1;
                    w.notifyAll();
                }
                c.remove(id);
            }
        }
    }

    public void remove(short client) {
        this.setClientState(client, (byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientState(short client, byte state) {
        Short key = ShortList.get((short)client);
        Map<Short, Map<ProfileItemID, Waiter>> map = this.clients;
        synchronized (map) {
            HashMap c = (HashMap)this.clients.get(key);
            if (c != null) {
                Iterator i = c.values().iterator();
                while (i.hasNext()) {
                    Waiter w;
                    Waiter waiter = w = (Waiter)i.next();
                    synchronized (waiter) {
                        w.result = state;
                        w.notifyAll();
                    }
                }
                this.clients.remove(key);
            }
        }
    }

    class Waiter {
        byte result = 0;

        Waiter() {
        }
    }
}

