/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.Notification;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;

public abstract class SwingLocationHandler
implements LocationHandler {
    protected SwingRunner runner;
    protected Logger logger;

    @Inject
    public void initSwingRunner(SwingRunner runner) {
        this.runner = runner;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    public void addFeature(Feature feature) {
        this.runner.invokeLater((Runnable)new SwingAddFeature(feature));
    }

    public void removeFeature(Feature feature) {
        this.runner.invokeLater((Runnable)new SwingRemoveFeature(feature));
    }

    public void announceFeature(Feature feature) {
        this.runner.invokeLater((Runnable)new SwingAnnounceFeature(feature));
    }

    public void deliverNotification(Notification n) {
        this.runner.invokeLater((Runnable)new SwingDeliverNotification(n));
    }

    public void abortNotification(Notification n) {
        this.runner.invokeLater((Runnable)new SwingAbortNotification(n));
    }

    public void announceNotification(Notification n) {
        this.runner.invokeLater((Runnable)new SwingAnnounceNotification(n));
    }

    protected abstract void addFeatureSwing(Feature var1);

    protected abstract void removeFeatureSwing(Feature var1);

    protected void announceFeatureSwing(Feature f) {
    }

    protected void deliverNotificationSwing(Notification n) {
    }

    protected void abortNotificationSwing(Notification n) {
    }

    protected void announceNotificationSwing(Notification n) {
    }

    protected boolean canAdd(Feature f) {
        return true;
    }

    class SwingAbortNotification
    implements Runnable {
        private Notification notification;

        public SwingAbortNotification(Notification n) {
            this.notification = n;
        }

        @Override
        public void run() {
            try {
                SwingLocationHandler.this.abortNotificationSwing(this.notification);
            }
            catch (Throwable t) {
                SwingLocationHandler.this.logger.exception((Object)this, "run", t, true);
            }
        }
    }

    class SwingAddFeature
    implements Runnable {
        private Feature feature;

        public SwingAddFeature(Feature f) {
            this.feature = f;
        }

        @Override
        public void run() {
            try {
                if (SwingLocationHandler.this.canAdd(this.feature)) {
                    SwingLocationHandler.this.addFeatureSwing(this.feature);
                }
            }
            catch (Throwable t) {
                SwingLocationHandler.this.logger.exception((Object)this, "run", t, true);
            }
        }
    }

    class SwingAnnounceFeature
    implements Runnable {
        private Feature feature;

        public SwingAnnounceFeature(Feature f) {
            this.feature = f;
        }

        @Override
        public void run() {
            try {
                SwingLocationHandler.this.announceFeatureSwing(this.feature);
            }
            catch (Throwable t) {
                SwingLocationHandler.this.logger.exception((Object)this, "run", t, true);
            }
        }
    }

    class SwingAnnounceNotification
    implements Runnable {
        private Notification notification;

        public SwingAnnounceNotification(Notification n) {
            this.notification = n;
        }

        @Override
        public void run() {
            try {
                SwingLocationHandler.this.announceNotificationSwing(this.notification);
            }
            catch (Throwable t) {
                SwingLocationHandler.this.logger.exception((Object)this, "run", t, true);
            }
        }
    }

    class SwingDeliverNotification
    implements Runnable {
        private Notification notification;

        public SwingDeliverNotification(Notification n) {
            this.notification = n;
        }

        @Override
        public void run() {
            try {
                SwingLocationHandler.this.deliverNotificationSwing(this.notification);
            }
            catch (Throwable t) {
                SwingLocationHandler.this.logger.exception((Object)this, "run", t, true);
            }
        }
    }

    class SwingRemoveFeature
    implements Runnable {
        private Feature feature;

        public SwingRemoveFeature(Feature f) {
            this.feature = f;
        }

        @Override
        public void run() {
            try {
                SwingLocationHandler.this.removeFeatureSwing(this.feature);
            }
            catch (Throwable t) {
                SwingLocationHandler.this.logger.exception((Object)this, "run", t, true);
            }
        }
    }
}

