/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class SelectionParameterSource
implements PropertyChangeListener {
    private ParticipantSelectorAPI selector = null;
    private PartSource participants = new PartSource();
    private RoomSource rooms = new RoomSource();

    @Inject
    public void init(Imps imps) {
        this.selector = (ParticipantSelectorAPI)imps.findBest(ParticipantSelectorAPI.class);
        if (this.selector != null) {
            this.selector.addPropertyChangeListener((PropertyChangeListener)this);
        } else {
            imps.addImpsAvailableListener((ImpsAvailableListener)new ImpsAvailableListener<ParticipantSelectorAPI>(){

                public void available(ParticipantSelectorAPI instance) {
                    SelectionParameterSource.this.selector = instance;
                    SelectionParameterSource.this.selector.addPropertyChangeListener((PropertyChangeListener)SelectionParameterSource.this);
                }

                public void removed(ParticipantSelectorAPI instance) {
                    if (SelectionParameterSource.this.selector == instance) {
                        SelectionParameterSource.this.selector.removePropertyChangeListener((PropertyChangeListener)SelectionParameterSource.this);
                        SelectionParameterSource.this.selector = null;
                    }
                }
            }, ParticipantSelectorAPI.class);
        }
    }

    public ParameterSource<CRParticipant> getParticipantParameterSource() {
        return this.participants;
    }

    public ParameterSource<CRRoom> getRoomParameterSource() {
        return this.rooms;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("selectedParicipantCount")) {
            this.participants.setCount((Integer)evt.getNewValue());
        } else if (prop.equals("selectedRoomCount")) {
            this.rooms.setCount((Integer)evt.getNewValue());
        }
    }

    class PartSource
    extends Source
    implements ParameterSource<CRParticipant> {
        PartSource() {
        }

        @Override
        public Collection<CRParticipant> getParameters() {
            if (SelectionParameterSource.this.selector == null) {
                return new ArrayList<CRParticipant>(0);
            }
            return SelectionParameterSource.this.selector.getSelectedParticipants();
        }

        @Override
        public CRParticipant getParameter() {
            if (SelectionParameterSource.this.selector == null) {
                return null;
            }
            Iterator i$ = SelectionParameterSource.this.selector.getSelectedParticipants().iterator();
            if (i$.hasNext()) {
                CRParticipant part = (CRParticipant)i$.next();
                return part;
            }
            return null;
        }

        @Override
        public Class<?> getParameterType() {
            return CRParticipant.class;
        }
    }

    class RoomSource
    extends Source
    implements ParameterSource<CRRoom> {
        RoomSource() {
        }

        @Override
        public Collection<CRRoom> getParameters() {
            if (SelectionParameterSource.this.selector == null) {
                return new ArrayList<CRRoom>(0);
            }
            return SelectionParameterSource.this.selector.getSelectedRooms();
        }

        @Override
        public CRRoom getParameter() {
            if (SelectionParameterSource.this.selector == null) {
                return null;
            }
            Iterator i$ = SelectionParameterSource.this.selector.getSelectedRooms().iterator();
            if (i$.hasNext()) {
                CRRoom room = (CRRoom)i$.next();
                return room;
            }
            return null;
        }

        @Override
        public Class<?> getParameterType() {
            return CRRoom.class;
        }
    }

    class Source {
        protected int count = 0;
        private CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();

        Source() {
        }

        public int getParameterCount() {
            return this.count;
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.listeners.addIfAbsent(pcl);
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.listeners.remove(pcl);
        }

        void setCount(int n) {
            if (this.count != n) {
                PropertyChangeEvent event = new PropertyChangeEvent(this, "count", this.count, n);
                this.count = n;
                for (PropertyChangeListener lst : this.listeners) {
                    try {
                        lst.propertyChange(event);
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"setCount", (Throwable)t, (boolean)true);
                    }
                }
            }
        }
    }
}

