/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.gui.AccessibilityUtils;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumericFeatureAdapter
extends FeatureAdapter
implements PropertyChangeListener,
ChangeListener {
    private NumericFeature<Integer> feature;
    private JSlider slider;
    private JProgressBar progressBar;
    private Integer value;
    private Map<Class<?>, ParameterSource<?>> sources = new HashMap();

    void init(String prefix, NumericFeature<Integer> nf, JSlider s, Container c) {
        super.init(prefix, (Feature)nf, s, c);
        this.slider = s;
        this.feature = nf;
        this.value = 0;
        this.checkEnabled();
        if (this.feature.getValue() == null) {
            this.feature.setValue((Object)0);
        }
        this.slider.addChangeListener(this);
        this.feature.addMetaDataListener((MetaDataListener)this);
        this.setDescription();
        this.setAccessibilityInfo();
    }

    void init(String prefix, NumericFeature<Integer> nf, JProgressBar pb, Container c) {
        super.init(prefix, (Feature)nf, pb, c);
        this.progressBar = pb;
        this.feature = nf;
        this.value = 0;
        this.checkEnabled();
        if (this.feature.getValue() == null) {
            this.feature.setValue((Object)0);
        }
        this.progressBar.addChangeListener(this);
        this.feature.addMetaDataListener((MetaDataListener)this);
        this.setDescription();
        this.setAccessibilityInfo();
    }

    void init(String prefix, Collection<ParameterSource<?>> srcList, NumericFeature<Integer> nf, JSlider sl, Container c) {
        for (ParameterSource<?> src : srcList) {
            this.sources.put(src.getParameterType(), src);
        }
        this.init(prefix, nf, sl, c);
    }

    void init(String prefix, Collection<ParameterSource<?>> srcList, NumericFeature<Integer> nf, JProgressBar bar, Container c) {
        for (ParameterSource<?> src : srcList) {
            this.sources.put(src.getParameterType(), src);
        }
        this.init(prefix, nf, bar, c);
    }

    private void setAccessibilityInfo() {
        String name = this.feature.getAccessibleName() != null ? this.feature.getAccessibleName() : this.feature.getName();
        String description = this.feature.getAccessibleDescription() != null ? this.feature.getAccessibleDescription() : this.feature.getDescription();
        AccessibilityUtils.setAccessibleInfo((Object)this.slider, (String)name, (String)description);
    }

    @Override
    public void dispose() {
        this.getNumericFeature().removeMetaDataListener((MetaDataListener)this);
        for (ParameterSource<?> src : this.sources.values()) {
            src.removePropertyChangeListener(this);
        }
    }

    public NumericFeature<Integer> getNumericFeature() {
        return this.feature;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent e) {
        String id = e.getID();
        if (id.equals("Feature.enabled")) {
            this.checkEnabled();
        } else if (id.equals("ValueFeature.value")) {
            this.setValue();
        } else if (id.equals("Feature.description")) {
            this.setDescription();
        }
    }

    private void setValue() {
        if (!this.value.equals(this.feature.getValue())) {
            if (this.progressBar != null) {
                this.progressBar.setValue((Integer)this.feature.getValue());
            } else if (this.slider != null) {
                this.slider.setValue((Integer)this.feature.getValue());
            }
            this.value = (Integer)this.feature.getValue();
        }
    }

    private void setDescription() {
        String desc = this.feature.getDescription();
        if (this.slider != null) {
            this.slider.setToolTipText(desc);
        } else if (this.progressBar != null) {
            this.progressBar.setToolTipText(desc);
        }
    }

    private void checkEnabled() {
        boolean enabled = this.feature.isEnabled();
        if (this.slider != null) {
            this.slider.setEnabled(enabled);
        } else if (this.progressBar != null) {
            this.progressBar.setEnabled(enabled);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.checkEnabled();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.slider != null) {
            this.feature.setValue((Object)this.slider.getValue());
        }
    }

    @Override
    public void setHasText(boolean hasText) {
    }

    @Override
    public void setHasToolTip(boolean hasTip) {
    }
}

