/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.contentcapture;

import com.elluminate.contentcapture.CaptureBacklogCallback;
import com.elluminate.contentcapture.CaptureClientConnection;
import com.elluminate.contentcapture.CaptureLogicalImageRoot;
import com.elluminate.contentcapture.CaptureTextInput;
import com.elluminate.contentcapture.CaptureTile;
import com.elluminate.util.ApplicationProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class ContentCapture {
    public static ContentCapture instance = null;
    private static HashSet<JComponent> repaintExceptions = new HashSet();

    public static void setInstance(ContentCapture contentCapture) {
        instance = contentCapture;
    }

    public boolean alwaysEcho(JComponent c) {
        return this.isEchoingData() || repaintExceptions.contains(c);
    }

    public void addAlwaysEcho(JComponent c) {
        this.alwaysEcho(c, true);
    }

    private void alwaysEcho(JComponent c, boolean add) {
        repaintExceptions.add(c);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component component = c.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            this.alwaysEcho((JComponent)component, add);
        }
    }

    public void removeAlwaysEcho(JComponent c) {
        this.alwaysEcho(c, false);
    }

    public ContentCapture get() {
        return instance;
    }

    public abstract ContentCapture registerImageModule(String var1, String var2, Container var3, ImageIcon var4, byte var5, byte var6);

    public abstract ContentCapture registerTextModule(String var1, String var2, CaptureBacklogCallback var3, CaptureTextInput var4, ImageIcon var5, byte var6, byte var7);

    public abstract ContentCapture registerAudioModule(String var1, String var2, ImageIcon var3, byte var4, byte var5);

    public abstract boolean bindImageComponent(String var1, String var2, Container var3);

    public abstract AbstractButton getContentCaptureRecordingButton();

    public abstract boolean isContentCaptureEnabled();

    public abstract boolean isCapturingData();

    public abstract boolean isEchoingData();

    public abstract void setConditionData(byte[] var1);

    public abstract void sendAudio(short var1, byte[] var2);

    public abstract void sendAudioGrant(short var1, boolean var2);

    public abstract void sendIndexMark(String var1, String var2, String var3, long var4);

    public abstract void setSessionName(String var1);

    public abstract void setText(String var1);

    public abstract void setText(short var1, String var2);

    public abstract void setTime(long var1);

    public abstract void setTitle(String var1);

    public abstract void setFeedVisible(boolean var1);

    public abstract boolean canQuit(Component var1);

    public abstract void iconifyIfNotEchoing(Frame var1);

    public abstract void processArguments(ApplicationProperties var1);

    public abstract int getSendDelay();

    public abstract void unsubscribeFromFeed(String var1, CaptureClientConnection var2);

    public abstract short getFeedIndex(String var1);

    public abstract void addClient(CaptureClientConnection var1);

    public abstract boolean allowUpscale();

    public abstract ContentCapture getFeed(short var1);

    public abstract ContentCapture getFeed(String var1);

    public abstract String getFeedName(short var1);

    public abstract String getFeedName();

    public abstract CaptureLogicalImageRoot getImageRoot();

    public abstract Dimension getImageSize();

    public abstract void acceptSubscriberTextInput(String var1);

    public abstract boolean isImageSizeSet();

    public abstract void sendImageTiles(CaptureTile[] var1);

    public abstract long sessionTime(long var1);

    public abstract long sessionTime();

    public abstract void setSizeChanged(Dimension var1);

    public abstract void subscribeFeed(String var1, CaptureClientConnection var2, boolean var3);

    public abstract void start();

    public abstract void shutdown();
}

