/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.view.module;

import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.ValueChangeRequestListener;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.groupware.imps.view.ViewModeEvent;
import com.elluminate.groupware.imps.view.ViewModeListener;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.view.ViewDebug;
import com.elluminate.groupware.view.ViewProtocol;
import com.elluminate.groupware.view.ViewSwitchEnabledRule;
import com.elluminate.groupware.view.ViewSwitchPolicy;
import com.elluminate.groupware.view.ViewSwitchPolicyListener;
import com.elluminate.groupware.view.module.ViewAPIImpl;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ViewModule
extends AbstractClientModule
implements PropertyChangeListener,
ClientGroupListener,
ClientListener,
ValueChangeRequestListener<String> {
    static final String MODULE_NAME = "View";
    private static final String MODE_PATH = "/view/mode";
    private static final String DESCRIPTION = ".desc";
    private static final String NAME = ".name";
    private I18n i18n = I18n.create((Object)this);
    private FeatureBroker broker = null;
    private ClientProvider clientProvider = null;
    private Client client = null;
    private ClientList clients = null;
    private Logger logger = null;
    private Imps imps = null;
    private ViewAPIImpl api = null;
    private EnumeratedFeature<String> modeFeature = null;
    private CRSession session;
    private ViewSwitchPolicy viewSwitchPolicy;

    @Inject
    public ViewModule(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initViewSwitchPolicy(ViewSwitchPolicy policy) {
        this.viewSwitchPolicy = policy;
    }

    @Inject
    public void intiViewAPI(ViewAPIImpl api) {
        this.api = api;
        api.addViewModeListener(new ViewModeListener(){

            public void modeChanged(ViewModeEvent event) {
                if (ViewModule.this.modeFeature != null) {
                    ViewModule.this.modeFeature.setValue((Object)event.getNewMode().name());
                }
            }
        });
    }

    @Inject
    public void initCrSession(CRSession session) {
        this.session = session;
        session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onMeAdded(CRParticipantEvent event) {
                ViewModule.this.setUpViewSwitching();
            }
        });
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("view.mode".equals(name)) {
            short gid = this.clients.getPropertyGroup(event.getSource());
            if (ViewDebug.TRACE.show()) {
                this.logger.message((Object)this, "propertyChange", "GID = " + gid + ", myGroupID = " + this.clients.getMyGroupID());
            }
            if (gid == this.clients.getMyGroupID()) {
                String value = (String)event.getNewValue();
                if (ViewDebug.TRACE.show()) {
                    this.logger.message((Object)this, "propertyChange", "View mode changed to '" + value + "' from '" + event.getOldValue() + "' by server");
                }
                this.api.changeMode(value);
            }
        }
    }

    public void requestValueChange(ValueFeature<String> feature, String requestedValue) {
        if (ViewDebug.TRACE.show()) {
            this.logger.message((Object)this, "requestValueChange", "View mode change requested to '" + requestedValue + "' by user");
        }
        try {
            ViewMode newMode = ViewMode.valueOf((String)requestedValue);
            this.requestMode(newMode);
        }
        catch (Throwable t) {
            this.logger.exception((Object)this, "requestValueChange", t, true);
        }
    }

    boolean requestMode(ViewMode newMode) throws IllegalArgumentException {
        System.out.println("requesting " + newMode);
        if (this.clients == null) {
            this.logger.error((Object)this, "requestMode", "Change to mode with no client list.");
            return false;
        }
        ClientGroup group = this.clients.getMyGroup();
        short addr = this.client.getAddress();
        if (group != null) {
            if (this.viewSwitchPolicy.canSwitchTo(newMode, this.session.getMe())) {
                group.setProperty("view.mode", ViewProtocol.encode((ViewMode)newMode, (short)addr));
                return true;
            }
            return false;
        }
        this.logger.error((Object)this, "requestMode", "Change to mode when not in a group!");
        return false;
    }

    private void updateMode(String event) {
        if (this.clients == null) {
            this.logger.error((Object)this, "updateMode", "Change to mode with no client list.");
            return;
        }
        ClientGroup group = this.clients.getMyGroup();
        if (group != null) {
            String value = group.getProperty("view.mode", ViewProtocol.encode((ViewMode)ViewMode.WHITEBOARD, (short)0));
            if (ViewDebug.TRACE.show()) {
                this.logger.message((Object)this, "updateMode", "Updating mode to " + value + " on " + event);
            }
            this.api.changeMode(value);
        } else {
            this.logger.error((Object)this, "updateMode", "Change to mode when not in a group!: " + event);
        }
    }

    public void cleanupUI() {
        if (this.modeFeature != null) {
            this.broker.removeFeature(this.modeFeature);
        }
    }

    public void setupUI() {
        ViewMode[] modes = ViewMode.values();
        Object[] values = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            values[i] = modes[i].name();
        }
        this.modeFeature = this.broker.createEnumeratedFeature((Object)this, MODE_PATH, String.class, false, (Object)this.api.getMode().name(), values, "Mode", "The viewing mode of the session");
        this.modeFeature.setValueChangeRequestListener((ValueChangeRequestListener)this);
        for (Object nm : values) {
            this.modeFeature.setValueDescription(nm, this.i18n.getStringLegacy((String)nm + DESCRIPTION));
            this.modeFeature.setValueText(nm, this.i18n.getStringLegacy((String)nm + NAME));
        }
        this.modeFeature.setEnabled(false);
        this.broker.addFeature(this.modeFeature);
    }

    public void attach() {
        if (ViewDebug.TRACE.show()) {
            this.logger.message("Attaching view");
        }
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.client.addClientGroupListener((ClientGroupListener)this);
        this.clients.addClientListener((ClientListener)this);
        this.clients.addGroupPropertyChangeListener("view.mode", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
    }

    public void detach() {
        if (this.clients != null) {
            if (ViewDebug.TRACE.show()) {
                this.logger.message("Detaching view");
            }
            this.clients.removeGroupPropertyChangeListener("view.mode", (PropertyChangeListener)this);
            this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
            this.clients.removeClientListener((ClientListener)this);
            this.client.removeClientGroupListener((ClientGroupListener)this);
            this.clients = null;
            this.client = null;
        }
    }

    public void start() {
        this.imps.provideAPI(ViewAPI.class, (ImpsAPI)this.api);
    }

    private void setUpViewSwitching() {
        String[] permisions;
        CRPermissionChangeListener listener = new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent event) {
                ViewModule.this.evalEnabledSwitches();
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
            }
        };
        for (String p : permisions = new String[]{"ChairPermission", "WebTourPermission", "AppSharePermission"}) {
            this.session.getMe().addPermissionChangeListener(p, listener);
        }
        this.viewSwitchPolicy.setViewSwitchPolicyListener((ViewSwitchPolicyListener)this.api);
        this.viewSwitchPolicy.addRule(ViewMode.WHITEBOARD, new ViewSwitchEnabledRule(new String[]{"AppSharePermission", "WebTourPermission"}));
        this.viewSwitchPolicy.addRule(ViewMode.APPSHARE, new ViewSwitchEnabledRule(new String[]{"AppSharePermission"}));
        this.viewSwitchPolicy.addRule(ViewMode.WEBTOUR, new ViewSwitchEnabledRule(new String[]{"WebTourPermission"}));
    }

    public void evalEnabledSwitches() {
        this.viewSwitchPolicy.evalPolicy(this.session.getMe());
    }

    public void stop() {
        this.imps.revokeAPI(ViewAPI.class, (ImpsAPI)this.api);
        this.api = null;
    }

    public void clientGroupCreated(ClientGroupEvent event) {
    }

    public void clientGroupDeleted(ClientGroupEvent event) {
    }

    public void clientGroupChanged(ClientGroupEvent event) {
        if (event.getClient().isMe()) {
            if (ViewDebug.TRACE.show()) {
                ClientGroup grp = event.getGroup();
                String value = grp.getProperty("view.mode", ViewMode.WHITEBOARD.name());
                this.logger.message((Object)this, "clientGroupChanged", "Setting view mode to " + value + " on entry to group '" + grp.getName() + "'");
            }
            this.updateMode("group change");
        }
    }

    public void clientGroupRenamed(ClientGroupEvent event) {
    }

    public void onAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateMode("join");
        }
    }

    public void onRemoveClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateMode("leave");
        }
    }
}

