/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.view.module;

import com.elluminate.groupware.imps.ModeSwitchingEnabledEvent;
import com.elluminate.groupware.imps.ModeSwitchingEnabledListener;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.groupware.imps.view.ViewModeEvent;
import com.elluminate.groupware.imps.view.ViewModeListener;
import com.elluminate.groupware.view.ViewProtocol;
import com.elluminate.groupware.view.ViewSwitchPolicyListener;
import com.elluminate.groupware.view.module.ViewModule;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewAPIImpl
implements ViewAPI,
ViewSwitchPolicyListener {
    private ViewModule viewModule;
    private Logger logger;
    private List<ViewModeListener> modeListeners = new ArrayList<ViewModeListener>();
    private ListenerRegistry<ModeSwitchingEnabledListener> switchingEnabledRegistry;
    private Object lock = new Object();
    private volatile ViewMode mode = ViewMode.WHITEBOARD;
    private volatile short initiator = 0;
    private Map<ViewMode, Boolean> enabledSwitches = new HashMap<ViewMode, Boolean>();

    @Inject
    ViewAPIImpl(ViewModule viewModule, Logger logger) {
        this.viewModule = viewModule;
        this.logger = logger;
    }

    @Inject
    public void initListenerRegistryProvider(Provider<ListenerRegistry<ModeSwitchingEnabledListener>> provider) {
        this.switchingEnabledRegistry = (ListenerRegistry)provider.get();
    }

    public String getProvider() {
        return "View";
    }

    public byte getTier() {
        return 32;
    }

    public ViewMode getMode() {
        return this.mode;
    }

    public boolean requestMode(ViewMode mode) {
        return this.viewModule.requestMode(mode);
    }

    public short getInitiator() {
        return this.initiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewModeListener(ViewModeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ViewModeListener> newList = new ArrayList<ViewModeListener>(this.modeListeners);
            newList.add(listener);
            this.modeListeners = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewModeListener(ViewModeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ViewModeListener> newList = new ArrayList<ViewModeListener>(this.modeListeners);
            newList.remove(listener);
            this.modeListeners = newList;
        }
    }

    public void addModeSwitchingEnabledListener(ModeSwitchingEnabledListener listener) {
        this.switchingEnabledRegistry.add((Object)listener);
    }

    public void removeModeSwitchingEnabledListener(ModeSwitchingEnabledListener listener) {
        this.switchingEnabledRegistry.remove((Object)listener);
    }

    public void enableViewSwitch(ViewMode mode, boolean flag) {
        Boolean prev;
        Boolean next = flag;
        if (next.equals(prev = this.enabledSwitches.get(mode))) {
            return;
        }
        this.enabledSwitches.put(mode, next);
        final ModeSwitchingEnabledEvent event = new ModeSwitchingEnabledEvent(mode, prev, next);
        this.switchingEnabledRegistry.fire((FiringFunctor)new FiringFunctor<ModeSwitchingEnabledListener>(){

            public void fire(ModeSwitchingEnabledListener listener) {
                listener.modeSwitchingEnabled(event);
            }
        });
    }

    public void changeMode(String newMode) {
        try {
            ViewMode was = this.mode;
            if (newMode == null) {
                this.mode = ViewMode.WHITEBOARD;
                this.initiator = 0;
            } else {
                this.mode = ViewProtocol.getMode((String)newMode);
                this.initiator = ViewProtocol.getAddress((String)newMode);
            }
            ViewMode now = this.mode;
            short who = this.initiator;
            if (was != now) {
                ViewModeEvent event = new ViewModeEvent((Object)this, was, now, who);
                for (ViewModeListener listener : this.modeListeners) {
                    try {
                        listener.modeChanged(event);
                    }
                    catch (Throwable t) {
                        this.logger.exception((Object)this, "changeMode", t, true);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Invalid mode '" + newMode + "'");
        }
    }
}

