/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.PlaybackSliderModel;
import com.elluminate.groupware.player.module.SeekTimeListener;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SeekTimeModel
implements ChangeListener {
    private long prevDif;
    private long prevTime;
    private long count;
    private long rateTotal;
    private long prevDesiredTime = -1L;
    private ListenerRegistry<SeekTimeListener> registry;

    @Inject
    public void initListenerRegistry(ListenerRegistry<SeekTimeListener> lr) {
        this.registry = lr;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        PlaybackSliderModel model = (PlaybackSliderModel)event.getSource();
        if (!model.isSynchronized()) {
            long dif = model.getPlayingTime() - model.getDesiredTime();
            if (dif > 0L) {
                return;
            }
            if (this.isNewDesiredTime(model.getDesiredTime())) {
                this.clear();
                return;
            }
            this.prevDesiredTime = model.getDesiredTime();
            if (this.prevDif != 0L) {
                long averageRate;
                long timeDelta = System.currentTimeMillis() - this.prevTime;
                if (timeDelta < 1000L) {
                    return;
                }
                long syncDelta = dif - this.prevDif;
                long rate = syncDelta / timeDelta;
                this.rateTotal += rate;
                if ((averageRate = this.rateTotal / ++this.count) != 0L) {
                    this.fireSeekTimeChanged(Math.abs(dif / averageRate / 1000L));
                }
            }
            this.prevDif = dif;
            this.prevTime = System.currentTimeMillis();
        } else {
            this.clear();
        }
    }

    public void addSeekTimeListener(SeekTimeListener listener) {
        if (listener != null) {
            this.registry.add((Object)listener);
        }
    }

    public void removeSeekTimeListener(SeekTimeListener listener) {
        if (listener != null) {
            this.registry.remove((Object)listener);
        }
    }

    private boolean isNewDesiredTime(long desiredTime) {
        return this.prevDesiredTime != -1L && desiredTime != this.prevDesiredTime;
    }

    private void clear() {
        this.fireSeekTimeChanged(0L);
        this.prevDif = 0L;
        this.prevTime = 0L;
        this.count = 0L;
        this.rateTotal = 0L;
        this.prevDesiredTime = -1L;
    }

    private void fireSeekTimeChanged(final long seconds) {
        this.registry.fire((FiringFunctor)new FiringFunctor<SeekTimeListener>(){

            public void fire(SeekTimeListener listener) {
                listener.seekTimeChanged(seconds);
            }
        });
    }
}

