/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.PlayerDebug;
import com.elluminate.groupware.player.module.PlayerStateChangeListener;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;

public class PlayerModel {
    private static final Object lock = new Object();
    private Logger log;
    private ListenerRegistry<PlayerStateChangeListener> registry;
    private STATE currentState = STATE.STOPPED;
    private STATE previousState = STATE.STOPPED;
    private STATE savedState = STATE.STOPPED;
    public static final float LINEAR_RATE = 1.0f;
    public static final float FAST_RATE = 8.0f;
    public static final float SEEK_RATE = 10000.0f;

    @Inject
    public void initLogger(Logger log) {
        this.log = log;
    }

    @Inject
    public void initListenerRegistry(ListenerRegistry<PlayerStateChangeListener> lr) {
        this.registry = lr;
    }

    protected void setState(STATE state) {
        this.setState(state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(STATE state, String caller) {
        if (state == this.currentState) {
            return;
        }
        if (PlayerDebug.STATE_CHANGE.show()) {
            this.logStateChange(state, caller);
        }
        if (state == STATE.PLAYING) {
            System.out.println("PlayerModel.setState: Playing");
        }
        Object object = lock;
        synchronized (object) {
            state = this.modifyState(state);
            this.previousState = this.currentState;
            this.currentState = state;
            this.registry.fire((FiringFunctor)new FiringFunctor<PlayerStateChangeListener>(){

                public void fire(PlayerStateChangeListener listener) {
                    listener.playerStateChanged(PlayerModel.this.previousState, PlayerModel.this.currentState);
                }
            });
        }
    }

    private void logStateChange(STATE state, String caller) {
        this.log.message((Object)this, "setState", "src[" + caller + "] " + "new[(" + (Object)((Object)state) + ")-" + state.name() + "] " + "current[(" + (Object)((Object)this.currentState) + ")-" + this.currentState.name() + "] " + "previous[(" + (Object)((Object)this.previousState) + ")-" + this.previousState.name() + "] " + "saved[(" + (Object)((Object)this.savedState) + ")-" + this.savedState.name() + "] " + "Thread[" + Thread.currentThread().getName() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private STATE modifyState(STATE newState) {
        STATE modifiedState = newState;
        Object object = lock;
        synchronized (object) {
            if (newState == STATE.RESUME) {
                modifiedState = this.savedState;
            }
        }
        if (PlayerDebug.STATE_CHANGE.show() && modifiedState != newState) {
            this.log.message("switching state to[(" + (Object)((Object)modifiedState) + ")-" + modifiedState.name() + "]");
        }
        return modifiedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerStateChangeListener(PlayerStateChangeListener listener) {
        if (listener != null) {
            Object object = lock;
            synchronized (object) {
                this.registry.add((Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerStateChangeListener(PlayerStateChangeListener listener) {
        if (listener != null) {
            Object object = lock;
            synchronized (object) {
                this.registry.remove((Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected STATE getCurrentState() {
        Object object = lock;
        synchronized (object) {
            return this.currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean inState(STATE state) {
        Object object = lock;
        synchronized (object) {
            return state == this.currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STATE getPreviousState() {
        Object object = lock;
        synchronized (object) {
            return this.previousState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCurrentState() {
        Object object = lock;
        synchronized (object) {
            this.savedState = this.currentState;
        }
    }

    public static enum STATE {
        STOPPED,
        PLAYING,
        PAUSED,
        FAST_FWD,
        SEEKING,
        RESUME;

    }
}

