/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.ContemporousIndexFilter;
import com.elluminate.groupware.player.module.FilteredIndexProvider;
import com.elluminate.groupware.player.module.TextMatchFilter;
import com.elluminate.jinx.VCRFile;
import com.elluminate.jinx.client.PlaybackClient;
import com.elluminate.jinx.provider.ConnectionProvider;
import com.google.inject.Inject;

public class PlayerIndexUtils {
    private ContemporousIndexFilter dupeFilter = new ContemporousIndexFilter(2000);
    private TextMatchFilter textFilter = new TextMatchFilter();
    private FilteredIndexProvider filterer = null;
    private final Object filtererLock = new Object();
    private ConnectionProvider clientProvider = null;

    @Inject
    public void initConnectionProvider(ConnectionProvider cp) {
        this.clientProvider = cp;
    }

    VCRFile.IndexEntry[] getFilteredIndex() {
        VCRFile.IndexEntry[] index = null;
        if (this.getFilterer() != null) {
            index = (VCRFile.IndexEntry[])this.getFilterer().getData();
        }
        if (index == null) {
            index = new VCRFile.IndexEntry[]{};
        }
        return index;
    }

    VCRFile.IndexEntry[] getRawIndex() {
        PlaybackClient pbc = (PlaybackClient)this.clientProvider.get();
        VCRFile.IndexEntry[] index = null;
        if (pbc != null) {
            index = pbc.getRecordingIndex();
        }
        if (index == null) {
            index = new VCRFile.IndexEntry[]{};
        }
        return index;
    }

    ContemporousIndexFilter getDuplicatesFilter() {
        return this.dupeFilter;
    }

    TextMatchFilter getTextFilter() {
        return this.textFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FilteredIndexProvider getFilterer() {
        Object object = this.filtererLock;
        synchronized (object) {
            if (this.filterer == null) {
                this.filterer = this.createFilterer();
            }
        }
        return this.filterer;
    }

    protected FilteredIndexProvider createFilterer() {
        PlaybackClient pbc = (PlaybackClient)this.clientProvider.get();
        if (pbc == null) {
            return null;
        }
        if (pbc.getRecordingIndexProvider() == null) {
            return null;
        }
        FilteredIndexProvider fp = null;
        fp = new FilteredIndexProvider(pbc.getRecordingIndexProvider());
        fp.addFilter(this.textFilter);
        fp.addFilter(this.dupeFilter);
        return fp;
    }

    int findClosest(VCRFile.IndexEntry[] index, long time, long duration) {
        long delta;
        long prevDelta = time;
        if (time < 0L) {
            return -1;
        }
        for (int ix = 0; ix < index.length; ++ix) {
            delta = index[ix].getTime() - time;
            if (prevDelta < delta) {
                return ix - 1;
            }
            prevDelta = Math.abs(delta);
        }
        delta = duration - time;
        if (prevDelta < delta) {
            return index.length - 1;
        }
        return index.length;
    }

    int findSuccessor(VCRFile.IndexEntry[] index, long time) {
        if (time < 0L) {
            return 0;
        }
        for (int ix = 0; ix < index.length; ++ix) {
            if (index[ix].getTime() <= time + 500L) continue;
            return ix;
        }
        return index.length;
    }

    int findPredecessor(VCRFile.IndexEntry[] index, long time) {
        if (time < 0L) {
            return -1;
        }
        for (int ix = 0; ix < index.length; ++ix) {
            if (index[ix].getTime() < time - 500L) continue;
            return ix - 1;
        }
        return index.length - 1;
    }
}

