/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.PlayerDebug;
import com.elluminate.groupware.player.module.IndexTimeComparator;
import com.elluminate.groupware.player.module.PlaybackSliderModel;
import com.elluminate.groupware.player.module.PlayerIndexUtils;
import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.gui.I18nUI;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.SearchTextField;
import com.elluminate.gui.swing.CTable;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.gui.swing.TableSorter;
import com.elluminate.jinx.VCRFile;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.elluminate.util.event.DataProvider;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class IndexDialog
extends EasyDialog
implements ActionListener,
ChangeListener,
Runnable {
    private static final int COLUMN_PLAY = 0;
    private static final int COLUMN_TIME = 1;
    private static final int COLUMN_MODULE = 2;
    private static final int COLUMN_KIND = 3;
    private static final int COLUMN_DETAIL = 4;
    private static final int NUM_COLUMNS = 5;
    private Icon playingIcon = null;
    private JPanel mainPane = new JPanel(new BorderLayout(6, 6));
    private JPanel topPane = new JPanel(new GridLayout(1, 2));
    private JLabel label = null;
    private CTable table = null;
    private IndexDataModel model = null;
    private TableSorter sorter = null;
    private JScrollPane scroller = null;
    private SearchTextField search = null;
    private JCheckBox filterDupesBtn = null;
    private JButton doneBtn = null;
    private JButton seekBtn = null;
    private PlaybackSliderModel slider = null;
    private int currentIndex = 0;
    private PlayerIndexUtils indexUtils = null;
    private I18n i18n = null;
    private Frame parent;

    @Inject
    public IndexDialog(DialogParentProvider parentProv, I18n loc, PlaybackSliderModel slider, PlayerIndexUtils utils) {
        super((Component)parentProv.getDialogParent(), loc.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_TITLE), false);
        this.i18n = loc;
        this.slider = slider;
        this.indexUtils = utils;
        this.parent = parentProv.getDialogParent();
        this.launch();
    }

    private void launch() {
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.playingIcon = this.i18n.getIcon("IndexDialog.playingIcon");
        this.label = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_TABLELABEL));
        this.model = new IndexDataModel(this.indexUtils.getFilterer());
        this.sorter = new TableSorter((TableModel)this.model);
        this.table = new CTable((TableModel)this.sorter);
        this.scroller = new JScrollPane((Component)this.table, 22, 30);
        this.search = new SearchTextField();
        this.search.setMaximumHistoryLength(0);
        this.search.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_SEARCHTIP));
        this.search.addTextChangeListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                IndexDialog.this.indexUtils.getTextFilter().setPattern(IndexDialog.this.search.getText());
                IndexDialog.this.indexUtils.getFilterer().invalidateData();
            }
        });
        this.filterDupesBtn = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_FILTERDUPESBTN));
        this.filterDupesBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_FILTERDUPESTIP));
        this.doneBtn = this.makeButton(4);
        this.doneBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_DONEBTNTIP));
        this.seekBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_SEEKBTN));
        this.seekBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_SEEKBTNTIP));
        this.seekBtn.setEnabled(false);
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setDefaultRenderer(I18nMessage.class, (TableCellRenderer)new MessageRenderer());
        this.table.setDefaultRenderer(Long.class, (TableCellRenderer)new TimeStampRenderer());
        this.table.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_TABLETIP));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_TABLEHEADERTIP));
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.sorter.setColumnAllowed(0, false);
        this.sorter.setColumnComparator(1, (Comparator)new IndexTimeComparator());
        this.sorter.setDefaultSort(1, true);
        Dimension cellSpacing = this.table.getIntercellSpacing();
        this.table.setIntercellSpacing(cellSpacing);
        this.table.setColumnAlignment(1, 11);
        this.table.setColumnAlignment(0, 0);
        this.table.setColumnAlignment(2, 0);
        int prefBodyWidth = this.setColumnWidths();
        if (PlayerDebug.INDEX_COLUMNS.show()) {
            LogSupport.message((Object)this, (String)"<init>", (String)("Preferred table width=" + prefBodyWidth));
        }
        int maxWidth = 640;
        int maxHeight = 480;
        if (this.parent != null) {
            maxWidth = (this.parent.getGraphicsConfiguration().getBounds().width * 4 + 2) / 5;
            maxHeight = (this.parent.getGraphicsConfiguration().getBounds().height * 4 + 2) / 5;
        } else {
            Dimension scrn = Toolkit.getDefaultToolkit().getScreenSize();
            if (scrn != null) {
                maxWidth = (scrn.width * 4 + 2) / 5;
                maxHeight = (scrn.height * 4 + 2) / 5;
            }
        }
        int prefBodyHeight = Math.max(128, (this.model.getRowCount() + 1) * 16);
        Dimension prefSize = new Dimension();
        prefSize.height = Math.min(maxHeight - 64, prefBodyHeight + this.table.getTableHeader().getHeight());
        prefSize.width = Math.min(maxWidth, prefBodyWidth);
        this.table.setPreferredScrollableViewportSize(prefSize);
        if (PlayerDebug.INDEX_COLUMNS.show()) {
            LogSupport.message((Object)this, (String)"<init>", (String)("Preferred viewport=" + prefSize));
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                IndexDialog.this.seekBtn.setEnabled(IndexDialog.this.table.getSelectedRow() >= 0);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                int MOD_KEYS_MASK = 15;
                if (ev.isConsumed()) {
                    return;
                }
                if ((ev.getModifiers() & 0xF) != 0) {
                    return;
                }
                if (IndexDialog.this.table.getSelectedRow() < 0) {
                    return;
                }
                if (ev.getClickCount() == 2) {
                    IndexDialog.this.seekToSelectedIndex();
                }
            }
        });
        if (Platform.getLAF() == 502) {
            this.scroller.setBackground(null);
            CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.scroller.getBorder());
            this.scroller.setBorder(b);
        }
        this.scroller.getViewport().setBackground(this.table.getBackground());
        this.scroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                IndexDialog.this.table.clearSelection();
            }
        });
        this.seekBtn.addActionListener(this);
        this.filterDupesBtn.addActionListener(this);
        this.topPane.add(this.label);
        this.topPane.add((Component)this.search);
        this.mainPane.add((Component)this.topPane, "First");
        this.mainPane.add((Component)this.scroller, "Center");
        this.mainPane.add((Component)this.filterDupesBtn, "Last");
        this.setContent(this.mainPane);
        this.addPassiveComponent(this.seekBtn);
        this.addActionButton(this.doneBtn, true);
        this.setInitialFocus((Component)this.table);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.slider) {
            SwingRunnerSupport.invokeOnEventThread((Runnable)this);
        }
    }

    @Override
    public void run() {
        this.updatePlayPosition();
    }

    private void updatePlayPosition() {
        int pos;
        long t = this.slider.getDesiredTime();
        int previousPos = this.currentIndex;
        VCRFile.IndexEntry[] indexData = this.model.getIndexData();
        if (t <= 0L) {
            pos = -1;
        } else {
            pos = indexData.length - 1;
            for (int ix = 0; ix < indexData.length; ++ix) {
                long curTime = indexData[ix].getTime();
                if (curTime >= 0L && curTime <= t) continue;
                pos = ix - 1;
                break;
            }
            if (pos < -1) {
                pos = 0;
            }
        }
        if (pos < -1) {
            pos = -1;
        } else if (pos >= indexData.length) {
            pos = indexData.length - 1;
        }
        if (pos != previousPos) {
            this.currentIndex = pos;
            if (previousPos >= 0) {
                this.model.fireTableCellUpdated(previousPos, 0);
            }
            if (pos >= 0) {
                this.model.fireTableCellUpdated(pos, 0);
            }
            this.table.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.seekBtn) {
            this.seekToSelectedIndex();
        } else if (src == this.filterDupesBtn) {
            boolean e = this.filterDupesBtn.isSelected();
            if (this.indexUtils.getDuplicatesFilter().isEnabled() != e) {
                this.indexUtils.getDuplicatesFilter().setEnabled(e);
                this.indexUtils.getFilterer().invalidateData();
            }
        }
    }

    public void show() {
        this.slider.addChangeListener(this);
        SwingRunnerSupport.invokeOnEventThread((Runnable)this);
        this.filterDupesBtn.setSelected(this.indexUtils.getDuplicatesFilter().isEnabled());
        this.search.setText(this.indexUtils.getTextFilter().getPattern());
        super.show();
    }

    public void hide() {
        super.hide();
        this.slider.removeChangeListener(this);
    }

    private void seekToSelectedIndex() {
        int idx = this.table.getSelectedRow();
        if (idx < 0) {
            return;
        }
        this.slider.setDesiredTime(this.model.getIndexTime(this.sorter.getModelRow(idx)));
    }

    private int setColumnWidths() {
        int tablePrefWidth = 0;
        tablePrefWidth += this.setColumnWidthRange(0, 24, false) + 2;
        tablePrefWidth += this.setColumnWidthRange(1, 36, false) + 2;
        tablePrefWidth += this.setColumnWidthRange(2, 24, true) + 2;
        tablePrefWidth += this.setColumnWidthRange(3, 72, true) + 2;
        return (tablePrefWidth += this.setColumnWidthRange(4, 180, true) + 2) + 2;
    }

    private int setColumnWidthRange(int colIdx, int minLimit, boolean resizable) {
        int result = 0;
        TableColumn col = this.table.getColumnModel().getColumn(colIdx);
        Dimension max = new Dimension();
        Dimension min = new Dimension();
        this.table.getColumnWidthRange(colIdx, min, max);
        Dimension hdr = this.table.getColumnHeaderPreferredSize(colIdx);
        if (PlayerDebug.INDEX_COLUMNS.show()) {
            LogSupport.message((Object)this, (String)"setColumnWidthRange", (String)("Column " + colIdx + " data cell range: " + min.width + " .. " + max.width + " header preferred: " + hdr.width));
        }
        if (hdr != null && hdr.width > max.width) {
            max.width = hdr.width;
        }
        if (min.width < minLimit) {
            min.width = minLimit;
        }
        if (max.width < min.width) {
            max.width = min.width;
        }
        result = max.width;
        col.setResizable(resizable);
        if (resizable) {
            col.setPreferredWidth(result);
            col.setMinWidth(min.width);
        } else {
            col.setMinWidth(result);
            col.setMaxWidth(result);
        }
        if (PlayerDebug.INDEX_COLUMNS.show()) {
            LogSupport.message((Object)this, (String)"setColumnWidthRange", (String)("Column " + colIdx + " width=" + result + " min=" + col.getMinWidth() + " max=" + col.getMaxWidth()));
        }
        return result;
    }

    class IndexDataModel
    extends AbstractTableModel
    implements DataChangeListener {
        private DataProvider indexProvider = null;
        private volatile boolean dataInvalid = true;
        private int rowCount = 0;
        private VCRFile.IndexEntry[] indexData = null;
        private Long[] timeValue = null;
        private Runnable changeNotifier = null;

        IndexDataModel(DataProvider provider) {
            this.changeNotifier = new Runnable(){

                @Override
                public void run() {
                    IndexDataModel.this.fireTableDataChanged();
                }
            };
            this.indexProvider = provider;
            if (this.indexProvider != null) {
                this.indexProvider.addDataChangeListener((DataChangeListener)this);
            }
        }

        public void dataChanged(DataChangeEvent ev) {
            this.dataInvalid = true;
            SwingRunnerSupport.invokeLater((Runnable)this.changeNotifier);
        }

        VCRFile.IndexEntry[] getIndexData() {
            if (this.dataInvalid) {
                this.updateIndexData();
            }
            return this.indexData;
        }

        private void updateIndexData() {
            this.dataInvalid = false;
            this.indexData = this.indexProvider == null ? null : (VCRFile.IndexEntry[])this.indexProvider.getData();
            if (this.indexData != null) {
                this.rowCount = this.indexData.length;
                this.timeValue = new Long[this.rowCount];
            } else {
                this.rowCount = 0;
                this.timeValue = null;
            }
        }

        long getIndexTime(int row) {
            if (this.dataInvalid) {
                this.updateIndexData();
            }
            return this.indexData[row].getTime();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            if (this.dataInvalid) {
                this.updateIndexData();
            }
            return this.rowCount;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            Class<Object> result = Object.class;
            switch (col) {
                case 0: {
                    result = Icon.class;
                    break;
                }
                case 1: {
                    result = Long.class;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    result = I18nMessage.class;
                }
            }
            return result;
        }

        @Override
        public String getColumnName(int col) {
            String result = "";
            switch (col) {
                case 0: {
                    result = IndexDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_PLAYTABLEHEADING);
                    break;
                }
                case 1: {
                    result = " " + IndexDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_TIMETABLEHEADING) + " ";
                    break;
                }
                case 2: {
                    result = IndexDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_MODULETABLEHEADING);
                    break;
                }
                case 3: {
                    result = IndexDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_KINDTABLEHEADING);
                    break;
                }
                case 4: {
                    result = IndexDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INDEXDIALOG_DETAILTABLEHEADING);
                }
            }
            if (result == null || "".equals(result)) {
                result = " ";
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.dataInvalid) {
                this.updateIndexData();
            }
            if (row < 0 || row >= this.rowCount) {
                return null;
            }
            Object result = null;
            VCRFile.IndexEntry entry = this.indexData[row];
            switch (col) {
                case 0: {
                    if (row == IndexDialog.this.currentIndex) {
                        result = IndexDialog.this.playingIcon;
                        break;
                    }
                    result = null;
                    break;
                }
                case 2: {
                    result = entry.getModuleIntl();
                    break;
                }
                case 3: {
                    result = entry.getKindIntl();
                    break;
                }
                case 4: {
                    result = entry.getDetailIntl();
                    break;
                }
                case 1: {
                    if (this.timeValue[row] == null) {
                        this.timeValue[row] = new Long(entry.getTime());
                    }
                    result = this.timeValue[row];
                }
            }
            return result;
        }
    }

    class MessageRenderer
    extends DefaultTableCellRenderer {
        MessageRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setIcon(null);
            this.setText(null);
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (result instanceof JLabel && value instanceof I18nMessage) {
                JLabel label = (JLabel)result;
                I18nMessage message = (I18nMessage)value;
                Icon icon = I18nUI.getIcon((I18nMessage)message);
                if (icon != null) {
                    label.setIcon(icon);
                    label.setText(null);
                    label.setHorizontalAlignment(0);
                }
            }
            return result;
        }
    }

    class TimeStampRenderer
    extends DefaultTableCellRenderer {
        TimeStampRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            long ts;
            String text = null;
            this.setIcon(null);
            this.setText(null);
            text = value == null ? "" : (value instanceof Number ? ((ts = ((Number)value).longValue()) < 0L ? "" : StringUtils.formatTimeStamp((long)ts, (boolean)false)) : value.toString());
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, col);
        }
    }
}

