/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.IndexFilter;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18nMessage;

public class ContemporousIndexFilter
implements IndexFilter {
    private int threshold;
    private boolean enabled = true;

    public ContemporousIndexFilter() {
        this(500);
    }

    public ContemporousIndexFilter(int maxTime) {
        this.threshold = maxTime;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int maxTime) {
        this.threshold = maxTime;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public boolean accept(VCRFile.IndexEntry[] entryList, int idx) {
        if (!this.enabled) {
            return true;
        }
        if (entryList == null) {
            return false;
        }
        if (idx == entryList.length - 1) {
            return true;
        }
        if (entryList[idx] == null) {
            return false;
        }
        if (entryList[idx].getTime() < 0L) {
            return true;
        }
        if (entryList[idx + 1] == null) {
            return true;
        }
        I18nMessage curMod = entryList[idx].getModuleIntl();
        I18nMessage curKind = entryList[idx].getKindIntl();
        I18nMessage nextMod = entryList[idx + 1].getModuleIntl();
        I18nMessage nextKind = entryList[idx + 1].getKindIntl();
        if (curMod.equals((Object)nextMod) && curKind.equals((Object)nextKind)) {
            long dt = entryList[idx + 1].getTime() - entryList[idx].getTime();
            return dt > (long)this.threshold;
        }
        return true;
    }

    public String toString() {
        return super.toString() + " threshold=" + this.threshold + ",enabled=" + this.enabled;
    }
}

