/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.groupware.timer.module.TimerController;
import com.elluminate.groupware.timer.module.TimerEvent;
import com.elluminate.groupware.timer.module.TimerListener;
import com.elluminate.gui.FontUtils;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Font;
import javax.swing.JLabel;

public class TimerDisplayLabel
extends JLabel {
    private static final int THREAD_SCHEDULE_INTERVALS = 100;
    private static final int CHARACTERS_PER_TIME_PART = 2;
    private static final int MILLI_SECONDS_SECONDS_CONVERTER = 1000;
    private static final int MINUTES_SECONDS_CONVERTER = 60;
    private static final int HOURS_SECONDS_CONVERTER = 3600;
    private static final String TIME_PARTS_SEPARATOR = ":";
    private static final String DEFAULT_TIMER_LABEL = "00:00:00";
    private long millisecondsCount = 0L;
    private long startSystemTime = 0L;
    private long startMillisecondsCount = 0L;
    private short timerType = (short)2;
    private boolean doRunCounter = false;
    private int fontStyle;
    private int fontSize;

    public TimerDisplayLabel(int fontSize, int fontStyle) {
        super(DEFAULT_TIMER_LABEL);
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        Font font = FontUtils.setFontStyleAndSize((Font)this.getFont(), (int)fontStyle, (int)fontSize);
        this.setFont(font);
        TimerController.getInstance().addTimerListener(new TimerListener(){

            @Override
            public void changedState(TimerEvent event) {
                if (event.getNewState() != event.getOldState() && event.getNewState() == 84) {
                    TimerDisplayLabel.this.doRunCounter = false;
                }
            }
        });
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        Font font = FontUtils.setFontStyleAndSize((Font)this.getFont(), (int)this.fontStyle, (int)fontSize);
        this.setFont(font);
    }

    public void start(short type, long startMilliseconds) {
        this.startSystemTime = System.currentTimeMillis();
        int correctionMilliseconds = 0;
        if (type == 2) {
            correctionMilliseconds = 999;
        }
        TimerController.getInstance().changeState((byte)83);
        this.millisecondsCount = this.startMillisecondsCount = startMilliseconds + (long)correctionMilliseconds;
        this.updateDisplay(this.millisecondsCount);
        this.timerType = type;
        if (!this.doRunCounter) {
            this.doRunCounter = true;
            new TimerCounterThread().start();
        }
    }

    public void stop() {
        this.doRunCounter = false;
        this.millisecondsCount = 0L;
        TimerController.getInstance().changeState((byte)70);
    }

    public void pause() {
        TimerController.getInstance().changeState((byte)80);
    }

    public void correctMillisecondsToFullSecond() {
        long correctionMilliseconds = 0L;
        if (this.millisecondsCount > 0L) {
            if (this.timerType == 2) {
                if (correctionMilliseconds < 0L) {
                    correctionMilliseconds = 0L;
                }
            } else if (correctionMilliseconds > 0L) {
                correctionMilliseconds = 0L;
            }
            this.millisecondsCount += correctionMilliseconds;
        }
    }

    public void resume(long resumeMilliseconds) {
        if (resumeMilliseconds > 0L) {
            this.start(this.timerType, resumeMilliseconds);
        } else {
            this.start(this.timerType, 1L);
        }
    }

    public long getTimeLeft() {
        return this.millisecondsCount;
    }

    public void setTimeLeft(long currentTime) {
        this.millisecondsCount = currentTime;
        this.updateDisplay(this.millisecondsCount);
    }

    private void updateDisplay(long milliseconds) {
        long seconds = milliseconds / 1000L;
        final int hr = (int)(seconds / 3600L);
        final int min = (int)((seconds %= 3600L) / 60L);
        final int sec = (int)(seconds % 60L);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TimerDisplayLabel.this.setText(TimerDisplayLabel.this.prependZero("" + hr, 2) + TimerDisplayLabel.TIME_PARTS_SEPARATOR + TimerDisplayLabel.this.prependZero("" + min, 2) + TimerDisplayLabel.TIME_PARTS_SEPARATOR + TimerDisplayLabel.this.prependZero("" + sec, 2));
                TimerDisplayLabel.this.repaint();
            }
        });
    }

    private String prependZero(String orig, int characters) {
        while (orig.length() < characters) {
            orig = "0" + orig;
        }
        return orig;
    }

    private class TimerCounterThread
    extends Thread {
        public TimerCounterThread() {
            super("Timer Counter Thread");
        }

        @Override
        public void run() {
            while (TimerDisplayLabel.this.doRunCounter) {
                if (TimerController.getInstance().getState() == 83) {
                    long displayValue = TimerDisplayLabel.this.millisecondsCount;
                    try {
                        TimerCounterThread.sleep(100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    displayValue = TimerDisplayLabel.this.timerType == 1 ? TimerDisplayLabel.this.startMillisecondsCount + System.currentTimeMillis() - TimerDisplayLabel.this.startSystemTime : TimerDisplayLabel.this.startMillisecondsCount - (System.currentTimeMillis() - TimerDisplayLabel.this.startSystemTime);
                    TimerDisplayLabel.this.millisecondsCount = displayValue;
                    TimerDisplayLabel.this.updateDisplay(displayValue);
                    if (displayValue >= 0L || !TimerController.getInstance().isRunning()) continue;
                    TimerController.getInstance().changeState((byte)84);
                    continue;
                }
                try {
                    TimerCounterThread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

