/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.StartTimerCommand;
import com.elluminate.groupware.timer.TimerInfo;
import com.elluminate.groupware.timer.module.StringsProperties;
import com.elluminate.groupware.timer.module.TimerBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.StringTokenizer;

public class StartTimerCmd
extends AbstractCommand
implements StartTimerCommand {
    private Provider<TimerBean> beanProvider;
    private static final String NOTIFICATION_SOUND = "sound";
    private static final String NOTIFICATION_MESSAGE = "message";
    private int startingTime = 300000;
    private boolean visibleToParticipants = true;
    private String notificationTypes = "sound,message";
    private String name;
    private I18n i18n = I18n.create((Object)((Object)this));

    @Inject
    public void initTimerBeanProvider(Provider<TimerBean> bp) {
        this.beanProvider = bp;
    }

    public void setStartingTime(int startingTime) {
        this.startingTime = startingTime * 1000;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVisibleToParticipants(boolean visibleToParticipants) {
        this.visibleToParticipants = visibleToParticipants;
    }

    public String[] getAvailableNotificationTypes() {
        return new String[]{NOTIFICATION_SOUND, NOTIFICATION_MESSAGE};
    }

    public void setNotificationTypes(String notificationTypes) {
        this.notificationTypes = notificationTypes;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        TimerBean bean = (TimerBean)this.beanProvider.get();
        if (bean.isTimerPaused() || bean.isTimerRunning()) {
            throw new CommandContextException("A timer is already running", this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMERCMD_BADCONTEXTTIMERALREADYACTIVE));
        }
        boolean notifyWithSound = false;
        boolean notifyWithMessage = false;
        if (this.notificationTypes != null) {
            StringTokenizer st = new StringTokenizer(this.notificationTypes, ",");
            while (st.hasMoreTokens()) {
                String type = st.nextToken();
                if (type.equalsIgnoreCase(NOTIFICATION_SOUND)) {
                    notifyWithSound = true;
                    continue;
                }
                if (type.equalsIgnoreCase(NOTIFICATION_MESSAGE)) {
                    notifyWithMessage = true;
                    continue;
                }
                throw new CommandParameterException("Unidentified notification string: " + type, this.i18n.getString((PropertiesEnum)StringsProperties.STARTTIMERCMD_BADPARAMINVALIDNOTIFICATIONTYPE, new Object[]{type}));
            }
        }
        TimerInfo t = new TimerInfo();
        t.setTime((long)Math.max(this.startingTime, 0));
        t.setTimerType(this.startingTime > 0 ? (short)2 : 1);
        t.setTimerVisibility(this.visibleToParticipants ? (short)2 : 1);
        t.setIsAudibleAlert(notifyWithSound);
        t.setIsVisibleAlert(notifyWithMessage);
        t.setConfigurableString(this.name);
        bean.setReturnFocusFirstTime(true);
        bean.startTimer(t);
    }
}

