/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.jinx.Bytes;
import com.elluminate.util.I18n;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;

public class ProfileItemID {
    private static I18n i18n = I18n.create(ProfileItemID.class);
    public static final byte ID_PHOTO = 0;
    public static final byte ID_FIRST_NAME = 1;
    public static final byte ID_LAST_NAME = 2;
    public static final byte ID_FULL_NAME = 3;
    public static final byte ID_TITLE = 16;
    public static final byte ID_COMPANY = 17;
    public static final byte ID_HOME_PHONE = 32;
    public static final byte ID_WORK_PHONE = 33;
    public static final byte ID_CELL_PHONE = 34;
    public static final byte ID_HOME_EMAIL = 48;
    public static final byte ID_WORK_EMAIL = 49;
    public static final byte ID_HOME_ADR_STR = 64;
    public static final byte ID_HOME_ADR_LOC = 65;
    public static final byte ID_HOME_ADR_REG = 66;
    public static final byte ID_HOME_ADR_ZIP = 67;
    public static final byte ID_HOME_ADR_CNT = 68;
    public static final byte ID_WORK_ADR_STR = 69;
    public static final byte ID_WORK_ADR_LOC = 70;
    public static final byte ID_WORK_ADR_REG = 71;
    public static final byte ID_WORK_ADR_ZIP = 72;
    public static final byte ID_WORK_ADR_CNT = 73;
    public static final byte ID_URL = 80;
    public static final byte ID_CUSTOM = 127;
    public static final ProfileItemID PHOTO;
    public static final ProfileItemID FIRST_NAME;
    public static final ProfileItemID LAST_NAME;
    public static final ProfileItemID FULL_NAME;
    public static final ProfileItemID TITLE;
    public static final ProfileItemID COMPANY;
    public static final ProfileItemID HOME_PHONE;
    public static final ProfileItemID WORK_PHONE;
    public static final ProfileItemID CELL_PHONE;
    public static final ProfileItemID HOME_EMAIL;
    public static final ProfileItemID WORK_EMAIL;
    public static final ProfileItemID HOME_ADDRESS_STREET;
    public static final ProfileItemID HOME_ADDRESS_LOCALITY;
    public static final ProfileItemID HOME_ADDRESS_REGION;
    public static final ProfileItemID HOME_ADDRESS_POSTAL;
    public static final ProfileItemID HOME_ADDRESS_COUNTRY;
    public static final ProfileItemID WORK_ADDRESS_STREET;
    public static final ProfileItemID WORK_ADDRESS_LOCALITY;
    public static final ProfileItemID WORK_ADDRESS_REGION;
    public static final ProfileItemID WORK_ADDRESS_POSTAL;
    public static final ProfileItemID WORK_ADDRESS_COUNTRY;
    public static final ProfileItemID URL;
    private static Map<String, ProfileItemID> byName;
    private static Map<Byte, ProfileItemID> byID;
    private byte id;
    private String name = null;

    private ProfileItemID(byte id, String name) {
        this.id = id;
        this.name = name;
        byName.put(name, this);
        byID.put(Bytes.get((byte)id), this);
    }

    private ProfileItemID(String nm) {
        this.id = (byte)127;
        this.name = nm;
        byName.put(nm, this);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        try {
            return i18n.getStringLegacy("ProfileItemID." + this.name);
        }
        catch (Throwable t) {
            return this.name;
        }
    }

    public static ProfileItemID get(Element e) {
        String nm = e.getName();
        return ProfileItemID.get(nm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileItemID get(String nm) {
        ProfileItemID id = null;
        Map<String, ProfileItemID> map = byName;
        synchronized (map) {
            id = byName.get(nm);
            if (id == null) {
                id = new ProfileItemID(nm);
            }
        }
        return id;
    }

    public void send(DataOutputStream ostr) throws IOException {
        ostr.writeByte(this.id);
        if (this.id == 127) {
            ostr.writeUTF(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileItemID read(DataInputStream istr) throws IOException {
        byte iid = istr.readByte();
        ProfileItemID item = null;
        if (iid == 127) {
            String nm = istr.readUTF();
            Map<String, ProfileItemID> map = byName;
            synchronized (map) {
                item = byName.get(nm);
                if (item == null) {
                    item = new ProfileItemID(nm);
                }
            }
        }
        try {
            item = byID.get(Bytes.get((byte)iid));
        }
        catch (ArrayIndexOutOfBoundsException oobx) {
            item = null;
        }
        return item;
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    public int hashCode() {
        if (this.id == 127) {
            return this.name.hashCode();
        }
        return this.id;
    }

    public boolean equals(Object o) {
        try {
            ProfileItemID p = (ProfileItemID)o;
            if (this.id != 127) {
                return this.id == p.id;
            }
            return this.name.equals(p.name);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        byName = new HashMap<String, ProfileItemID>();
        byID = new HashMap<Byte, ProfileItemID>();
        PHOTO = new ProfileItemID(0, "photo");
        FIRST_NAME = new ProfileItemID(1, "name.first");
        LAST_NAME = new ProfileItemID(2, "name.last");
        FULL_NAME = new ProfileItemID(3, "name.full");
        TITLE = new ProfileItemID(16, "title");
        COMPANY = new ProfileItemID(17, "company");
        HOME_PHONE = new ProfileItemID(32, "phone.home");
        WORK_PHONE = new ProfileItemID(33, "phone.work");
        CELL_PHONE = new ProfileItemID(34, "phone.cell");
        HOME_EMAIL = new ProfileItemID(48, "email.home");
        WORK_EMAIL = new ProfileItemID(49, "email.work");
        HOME_ADDRESS_STREET = new ProfileItemID(64, "address.home.street");
        HOME_ADDRESS_LOCALITY = new ProfileItemID(65, "address.home.locality");
        HOME_ADDRESS_REGION = new ProfileItemID(66, "address.home.region");
        HOME_ADDRESS_POSTAL = new ProfileItemID(67, "address.home.postal");
        HOME_ADDRESS_COUNTRY = new ProfileItemID(68, "address.home.country");
        WORK_ADDRESS_STREET = new ProfileItemID(69, "address.work.street");
        WORK_ADDRESS_LOCALITY = new ProfileItemID(70, "address.work.locality");
        WORK_ADDRESS_REGION = new ProfileItemID(71, "address.work.region");
        WORK_ADDRESS_POSTAL = new ProfileItemID(72, "address.work.postal");
        WORK_ADDRESS_COUNTRY = new ProfileItemID(73, "address.work.country");
        URL = new ProfileItemID(80, "url");
    }

    public static class ItemIDComparator
    implements Comparator<ProfileItemID> {
        @Override
        public int compare(ProfileItemID id1, ProfileItemID id2) {
            if (id1.id < id2.id) {
                return -1;
            }
            if (id1.id > id2.id) {
                return 1;
            }
            if (id1.id != 127) {
                return 0;
            }
            return id1.name.compareTo(id2.name);
        }
    }
}

