/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.util.Base64;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ImageDataProfileItem
extends ProfileItem {
    public static final String MIME = "image/jpeg";
    public static final byte ITEM_TYPE = 2;
    protected byte[] data;
    protected int height;
    protected int width;

    public ImageDataProfileItem(ProfileItemID id, Image i) {
        super(id, (byte)2, MIME);
        throw new RuntimeException("Unable to create an ImageDataProfileItem from an image.");
    }

    public ImageDataProfileItem(ProfileItemID id, byte[] img, String mime) {
        super(id, (byte)2, MIME);
        if (mime.equals(MIME)) {
            this.data = new byte[img.length];
            System.arraycopy(img, 0, this.data, 0, img.length);
            return;
        }
        throw new RuntimeException("Unable to create an ImageDataProfileItem from " + mime + " data.");
    }

    public ImageDataProfileItem(ProfileItemID id, byte[] bytes, int h, int w) {
        super(id, (byte)2, MIME);
        if (bytes == null) {
            throw new IllegalArgumentException("Null image data reference.");
        }
        this.data = bytes;
        this.height = h;
        this.width = w;
    }

    public ImageDataProfileItem(Element e) throws JDOMException {
        super(ProfileItemID.get(e), (byte)2, MIME);
        Attribute h = e.getAttribute("height");
        Attribute w = e.getAttribute("width");
        if (h == null) {
            throw new JDOMException("Missing height attribute on " + e.getName() + " element");
        }
        if (w == null) {
            throw new JDOMException("Missing width attribute on " + e.getName() + " element");
        }
        this.height = h.getIntValue();
        this.width = w.getIntValue();
        String s = e.getTextTrim();
        try {
            this.data = Base64.decode((String)s);
        }
        catch (Throwable t) {
            throw new JDOMException("Invalid image data in image/jpeg item.");
        }
    }

    public ImageDataProfileItem(ProfileItemID id, DataInputStream str) throws IOException {
        super(id, (byte)2, MIME);
        this.height = str.readByte();
        this.width = str.readByte();
        int len = str.readInt();
        if (len > 65536) {
            throw new IOException("Invalid image length.");
        }
        this.data = new byte[len];
        str.readFully(this.data);
    }

    protected ImageDataProfileItem(ProfileItemID id) {
        super(id, (byte)2, MIME);
        this.data = null;
        this.height = 0;
        this.width = 0;
    }

    @Override
    public byte[] getRaw() {
        return this.data;
    }

    @Override
    public void send(DataOutputStream ostr) throws IOException {
        ostr.writeByte(this.kind);
        this.id.send(ostr);
        ostr.writeByte(this.height);
        ostr.writeByte(this.width);
        if (this.data != null) {
            ostr.writeInt(this.data.length);
            ostr.write(this.data);
        } else {
            ostr.writeInt(0);
        }
    }

    @Override
    public void sendDeferred(DataOutputStream ostr) throws IOException {
        ostr.writeByte(3);
        this.id.send(ostr);
        ostr.writeByte(this.height);
        ostr.writeByte(this.width);
        ostr.writeInt(this.data != null ? this.data.length : 0);
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void write(Element parent) {
        Element e = new Element(this.id.getName());
        e.setAttribute("mime", MIME);
        e.setAttribute("height", Integer.toString(this.height));
        e.setAttribute("width", Integer.toString(this.width));
        String s = Base64.encode((byte[])this.data, (int)72);
        e.addContent("\n");
        e.addContent(s);
        parent.addContent((Content)e);
    }

    public String toString() {
        return this.id + "(" + MIME + ")=[" + this.width + "x" + this.height + "," + this.data.length + " bytes]";
    }

    public boolean equals(Object o) {
        try {
            ImageDataProfileItem ipi = (ImageDataProfileItem)o;
            if (this.id != ipi.id) {
                return false;
            }
            if (this.height != ipi.height) {
                return false;
            }
            if (this.width != ipi.width) {
                return false;
            }
            if (this.data.length != ipi.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == ipi.data[i]) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.data.hashCode() ^ this.height ^ this.width;
    }
}

