/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.groupware.imps.ProfileDataAPI;
import com.elluminate.groupware.profile.Profile;
import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.groupware.profile.module.DeferredException;
import com.elluminate.groupware.profile.module.UpdateQueue;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.Connection;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointListener;
import com.elluminate.util.ShortList;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpRequest;
import com.elluminate.util.net.HttpResponse;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public class ProfileLibrary
implements ProfileDataAPI {
    public static final long DEFAULT_DELAY = 5000L;
    private Map<Short, Profile> profiles = new HashMap<Short, Profile>();
    private String base = null;
    private Thread server = null;
    private Channel channel = null;
    private EndpointListener listener = null;
    private UpdateQueue updates = new UpdateQueue();
    private Object pLock = new Object();
    private volatile boolean running = true;

    public ProfileLibrary() {
        try {
            InetAddress loopback;
            try {
                loopback = InetAddress.getByName("localhost");
            }
            catch (Throwable t) {
                loopback = InetAddress.getByName("127.0.0.1");
            }
            this.listener = new EndpointListener("direct", 0, 50, loopback);
            this.base = "http://127.0.0.1:" + this.listener.getLocalPort() + "/";
            this.server = new WorkerThread((Runnable)new Server(), "ProfileWebServer", 6);
            this.server.setDaemon(true);
            this.server.start();
        }
        catch (IOException iox) {
            this.base = null;
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.listener != null) {
            this.listener.closeForce();
        }
        this.server = null;
        this.base = null;
    }

    public void setChannel(Channel c) {
        this.channel = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfile(short addr, Profile p) {
        Object object = this.pLock;
        synchronized (object) {
            Short key = ShortList.get((short)addr);
            Profile old = this.profiles.get(key);
            if (old != null) {
                p.setChangeClock(old.getChangeClock() + 1);
            }
            this.profiles.put(key, p);
            this.updates.update(addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProfile(short addr) {
        Object object = this.pLock;
        synchronized (object) {
            this.profiles.remove(ShortList.get((short)addr));
            this.updates.remove(addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProfileItem(short addr, ProfileItem item) {
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p != null) {
                p.set(item);
            }
            this.updates.update(addr, item.getID());
        }
    }

    public Profile getProfile(short addr) {
        if (this.isDisabled()) {
            return null;
        }
        return this.profiles.get(ShortList.get((short)addr));
    }

    private boolean isDisabled() {
        if (this.channel == null) {
            return true;
        }
        Connection con = this.channel.getConnection();
        if (con == null) {
            return true;
        }
        if (con instanceof Client) {
            return ((Client)con).isObfuscatingNames();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image tryGetImage(short addr, ProfileItemID id) throws DeferredException {
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return null;
            }
            String mime = p.getMimeType(id);
            if ("image/jpeg".equals(mime)) {
                return p.getImage(id);
            }
            if ("image/proxy".equals(mime)) {
                if (this.channel == null) {
                    return null;
                }
                ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
                try {
                    DataOutputStream ostr = cde.write();
                    ostr.writeShort(addr);
                    id.send(ostr);
                    ostr.close();
                    this.channel.onChannelData(cde);
                    throw new DeferredException();
                }
                catch (IOException iox) {
                    LogSupport.exception((Object)this, (String)"tryGetImage", (Throwable)iox, (boolean)true);
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] tryGetRaw(short addr, String nm) throws DeferredException {
        ProfileItemID id = ProfileItemID.get((String)nm);
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return null;
            }
            String mime = p.getMimeType(id);
            if ("image/jpeg".equals(mime)) {
                return p.getRaw(id);
            }
            if ("image/proxy".equals(mime)) {
                if (this.channel == null) {
                    return null;
                }
                ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
                try {
                    DataOutputStream ostr = cde.write();
                    ostr.writeShort(addr);
                    ostr.writeUTF(nm);
                    ostr.close();
                    this.channel.onChannelData(cde);
                    throw new DeferredException();
                }
                catch (IOException iox) {
                    LogSupport.exception((Object)this, (String)"tryGetRaw", (Throwable)iox, (boolean)true);
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfileText(short addr, String nm) {
        ProfileItemID id = ProfileItemID.get((String)nm);
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return null;
            }
            return p.getString(id);
        }
    }

    public Image getProfileImage(short addr, String nm) {
        return this.getProfileImage(addr, nm, 5000L);
    }

    public Image getProfileImage(short addr, String nm, long wait) {
        ProfileItemID id = ProfileItemID.get((String)nm);
        long limit = System.currentTimeMillis() + wait;
        try {
            return this.tryGetImage(addr, id);
        }
        catch (DeferredException dx) {
            long delay;
            while ((delay = limit - System.currentTimeMillis()) > 0L) {
                if (this.updates.waitFor(addr, id, delay) == 2) {
                    return null;
                }
                try {
                    return this.tryGetImage(addr, id);
                }
                catch (DeferredException dx2) {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMimeType(short addr, String nm) {
        ProfileItemID id = ProfileItemID.get((String)nm);
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return null;
            }
            return p.getMimeType(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProfile(short addr) {
        boolean contains;
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            contains = p != null;
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProfileInfo(short addr, String nm) {
        ProfileItemID id = ProfileItemID.get((String)nm);
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return false;
            }
            return p.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfileHTML(short addr) {
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return null;
            }
            String jinxName = null;
            ClientInfo ci = this.channel.getConnection().getClientList().get(addr);
            if (ci != null) {
                jinxName = ci.getDisplayName();
            }
            if (this.base == null) {
                return p.getHTML(null, jinxName);
            }
            return p.getHTML(this.base + addr, jinxName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHtmlMinimumHeight(short addr) {
        Object object = this.pLock;
        synchronized (object) {
            Profile p = this.getProfile(addr);
            if (p == null) {
                return 0;
            }
            return p.getHtmlMinimumHeight();
        }
    }

    public String getProvider() {
        return "profile";
    }

    public byte getTier() {
        return 32;
    }

    private void runWebServer() {
        while (!Thread.interrupted() && !this.listener.isClosed()) {
            try {
                Endpoint ep = this.listener.accept();
                WorkerThread proc = new WorkerThread((Runnable)new Processor(ep), "ProfileWebRequestProcessor", 6);
                proc.setDaemon(true);
                proc.start();
            }
            catch (IOException iox) {
                if (!this.running) continue;
                LogSupport.exception((Object)this, (String)"runWebServer", (Throwable)iox, (boolean)true);
                break;
            }
        }
        if (this.running) {
            this.listener.closeForce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebRequests(Endpoint ep) {
        boolean running = true;
        DataInputStream istr = null;
        DataOutputStream ostr = null;
        try {
            istr = new DataInputStream(ep.getInputStream());
            ostr = new DataOutputStream(ep.getOutputStream());
        }
        catch (IOException iox) {
            running = false;
        }
        while (running) {
            try {
                byte[] data;
                short who;
                String name;
                HttpResponse resp;
                HttpRequest req;
                block18: {
                    req = new HttpRequest(istr, false);
                    resp = null;
                    String path = req.getURI();
                    if (!path.startsWith("/")) {
                        this.sendError(ostr);
                        running = false;
                        continue;
                    }
                    int slash = (path = path.substring(1)).indexOf(47);
                    if (slash <= 0) {
                        this.sendError(ostr);
                        running = false;
                        continue;
                    }
                    String addr = path.substring(0, slash);
                    name = path.substring(slash + 1);
                    who = -32767;
                    data = null;
                    slash = name.indexOf(47);
                    if (slash > 0) {
                        name = name.substring(0, slash);
                    }
                    try {
                        who = Short.parseShort(addr);
                        data = this.tryGetRaw(who, name);
                    }
                    catch (NumberFormatException nfx) {
                        running = false;
                    }
                    catch (DeferredException dx) {
                        ProfileItemID id = ProfileItemID.get((String)name);
                        if (this.updates.waitFor(who, id, 1000L) != 1) break block18;
                        Object object = this.pLock;
                        synchronized (object) {
                            Profile p = this.getProfile(who);
                            if (p != null) {
                                data = p.getRaw(id);
                            }
                        }
                    }
                }
                if (data == null) {
                    this.sendError(ostr);
                    running = false;
                    continue;
                }
                try {
                    String mime = this.getMimeType(who, name);
                    resp = new HttpResponse(200, "OK", data.length, false, req.getHttpVersion(), false);
                    resp.setHeader("Content-Type", mime);
                    resp.setHeader("Cache-Control", "no-store");
                    resp.send(ostr);
                    ostr.write(data);
                }
                catch (Throwable t) {
                    this.sendError(ostr);
                    running = false;
                }
            }
            catch (IOException iox) {
                running = false;
            }
        }
        ep.closeForce();
    }

    private void sendError(DataOutputStream ostr) throws IOException {
        HttpResponse resp = new HttpResponse(404, "Not found", 0, true, 10, false);
        resp.send(ostr);
    }

    class Processor
    implements Runnable {
        Endpoint ep;

        public Processor(Endpoint ep) {
            this.ep = ep;
        }

        @Override
        public void run() {
            ProfileLibrary.this.processWebRequests(this.ep);
        }
    }

    class Server
    implements Runnable {
        Server() {
        }

        @Override
        public void run() {
            ProfileLibrary.this.runWebServer();
        }
    }
}

