/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.MultimediaProtocol;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.util.crypto.DiffieHellman;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class MediaLibraryEntry {
    private int uid;
    private String name;
    private String mime;
    private long length;
    private long acknowledged = 0L;
    private BigInteger auth;
    private StreamCache cache = null;
    private int nPlaying = 0;
    private short source = 0;
    private byte serverPct = 0;
    private short[] status = new short[MultimediaProtocol.STATUS_PCT.length];

    public MediaLibraryEntry(int id, long length, BigInteger auth, String name, String type) {
        this.uid = id;
        this.name = name;
        this.mime = type;
        this.length = length;
        this.auth = auth;
    }

    public MediaLibraryEntry(StreamCache cache, BigInteger auth, String name, String type) {
        this.cache = cache;
        this.uid = cache.getStreamID();
        this.auth = auth;
        this.name = name;
        this.mime = type;
        this.length = cache.getLength();
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mime;
    }

    public int getID() {
        return this.uid;
    }

    public long getLength() {
        return this.length;
    }

    public long getPosition() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getLocation();
    }

    public boolean isComplete() {
        return this.getLength() == this.getPosition();
    }

    public void setCache(StreamCache c) {
        this.cache = c;
    }

    public StreamCache getCache() {
        return this.cache;
    }

    public BigInteger getAuthCode() {
        return this.auth;
    }

    public void setSource(short src) {
        this.source = src;
    }

    public short getSource() {
        return this.source;
    }

    public boolean isServerComplete() {
        return this.serverPct == 100;
    }

    public boolean isLoading() {
        return this.serverPct >= 0 && this.serverPct < 100;
    }

    public boolean isIncomplete() {
        return this.serverPct < 0;
    }

    public byte getServerPercent() {
        return (byte)Math.abs(this.serverPct);
    }

    public boolean setServerPercent(byte pct) {
        boolean changed = this.serverPct != pct;
        this.serverPct = pct;
        return changed;
    }

    public short getStatusCount(int idx) {
        return this.status[idx];
    }

    public boolean setStatusCount(int idx, short n) {
        boolean changed = this.status[idx] != n;
        this.status[idx] = n;
        return changed;
    }

    public void setAcknowledged(long acked) {
        this.acknowledged = acked;
    }

    public long getAcknowledged() {
        return this.acknowledged;
    }

    public boolean isPlaying() {
        return this.nPlaying > 0;
    }

    void startPlaying() {
        ++this.nPlaying;
    }

    void stopPlaying() {
        --this.nPlaying;
    }

    public void endPlaying() {
        this.nPlaying = 0;
    }

    public void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
        this.nPlaying = 0;
    }

    public void encodeProgress(DataOutputStream str) throws IOException {
        str.writeInt(this.uid);
        str.writeByte(this.serverPct);
        for (int i = 0; i < this.status.length; ++i) {
            str.writeShort(this.status[i]);
        }
    }

    public void decodeProgress(DataInputStream str) throws IOException {
        this.serverPct = str.readByte();
        for (int i = 0; i < this.status.length; ++i) {
            this.status[i] = str.readShort();
        }
    }

    public void encodeStatus(DataOutputStream str, short addr) throws IOException {
        this.encodeStatus(str, addr, this.getPosition());
    }

    public void encodeStatus(DataOutputStream str, short addr, long from) throws IOException {
        str.writeInt(this.uid);
        str.writeUTF(this.name);
        str.writeUTF(this.mime);
        str.writeLong(this.length);
        str.writeLong(from);
        if (addr == 0 || this.auth == null) {
            str.writeUTF("");
        } else {
            str.writeUTF(DiffieHellman.getKeyString((BigInteger)this.auth, (String)Short.toString(addr)));
        }
    }
}

