/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.PromptToSaveFileCommand;
import com.elluminate.groupware.imps.filetransfer.FileTransferItem;
import com.elluminate.groupware.transfer.module.StringsProperties;
import com.elluminate.groupware.transfer.module.TransferBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class PromptToSaveFileCmd
extends AbstractCommand
implements PromptToSaveFileCommand {
    private String fileName;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<TransferBean> beanProvider;

    @Inject
    public void initChatBeanProvider(Provider<TransferBean> bp) {
        this.beanProvider = bp;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.fileName == null) {
            throw new CommandParameterException("File not specified", this.i18n.getString((PropertiesEnum)StringsProperties.PROMPTTOSAVEFILECMD_BADPARAMFILENOTSET));
        }
        FileTransferItem item = ((TransferBean)this.beanProvider.get()).getFile(this.fileName);
        if (item == null) {
            throw new CommandParameterException("File not found: " + this.fileName, this.i18n.getString((PropertiesEnum)StringsProperties.PROMPTTOSAVEFILECMD_BADPARAMFILENOTFOUND, new Object[]{this.fileName}));
        }
        ((TransferBean)this.beanProvider.get()).prompt(item.getUID());
    }
}

