/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.groupware.transfer.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;

class LengthCellRenderer
extends DefaultTableCellRenderer {
    static Color warn = new Color(255, 102, 0);
    static Color ok = new Color(0, 102, 0);
    private I18n i18n = I18n.create((Object)this);

    LengthCellRenderer() {
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            return;
        }
        long[] len = (long[])o;
        float pct = 1.0f;
        long sz = len[0];
        this.setHorizontalAlignment(11);
        if (sz > 0L) {
            pct = (float)len[1] / (float)sz;
        }
        if (sz < 10000L) {
            this.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_FORMATLENGTHB, new Object[]{new Long(sz), new Float(pct)}));
        } else if (sz < 0x100000L) {
            this.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_FORMATLENGTHK, new Object[]{new Long(sz / 1024L), new Float(pct)}));
        } else {
            this.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_FORMATLENGTHM, new Object[]{new Float((float)sz / 1048576.0f), new Float(pct)}));
        }
    }
}

