/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.groupware.transfer.module.FIDEvent;
import com.elluminate.groupware.transfer.module.FIDListener;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;

public class FIDClient
implements ChannelDataListener {
    private Channel chnl = null;
    private HashSet listeners = new HashSet();
    private Object listenerLock = new Object();
    private Object requestLock = new Object();
    private int nextReq = 1;
    private HashMap requests = new HashMap();

    public FIDClient(Channel chnl) {
        this.chnl = chnl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelData(ChannelDataEvent e) {
        if (e.getCommand() != 34) {
            LogSupport.error((Object)this, (String)"onChannelData", (String)("Unexpected message received by transfer ID processor - " + e.getCommand()));
            return;
        }
        try {
            DataInputStream istr = e.read();
            int req = istr.readInt();
            int id = istr.readInt();
            String rsp = istr.readUTF();
            Integer key = new Integer(req);
            BigInteger secret = null;
            Object object = this.requestLock;
            synchronized (object) {
                DiffieHellman dh = (DiffieHellman)this.requests.remove(key);
                if (dh != null) {
                    dh.setResponse(rsp);
                    secret = dh.getSecret();
                }
            }
            if (secret != null) {
                this.fireFIDAssigned(req, id, secret);
            }
            istr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFID(int req) {
        DiffieHellman dh;
        Object object = this.requestLock;
        synchronized (object) {
            dh = new DiffieHellman();
            this.requests.put(new Integer(req), dh);
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)33);
        try {
            DataOutputStream ostr = e.write();
            ostr.writeInt(req);
            ostr.writeUTF(dh.getChallenge());
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"requestFID", (Throwable)ex, (boolean)true);
            e.dispose();
            return;
        }
        this.chnl.onChannelData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFIDListener(FIDListener lst) {
        Object object = this.listenerLock;
        synchronized (object) {
            HashSet nl = (HashSet)this.listeners.clone();
            nl.add(lst);
            this.listeners = nl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFIDListener(FIDListener lst) {
        Object object = this.listenerLock;
        synchronized (object) {
            HashSet nl = (HashSet)this.listeners.clone();
            nl.remove(lst);
            this.listeners = nl;
        }
    }

    private void fireFIDAssigned(int req, int id, BigInteger auth) {
        FIDEvent e = new FIDEvent(this, req, id, auth);
        for (FIDListener lst : this.listeners) {
            try {
                lst.assignedFID(e);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireIDAssigned", (Throwable)t, (boolean)true);
            }
        }
    }
}

