/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.windows;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.gui.windows.WinDock;
import com.elluminate.gui.windows.WinHandle;
import com.elluminate.gui.windows.WinHotKey;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Frame;

public class WindowsGuiSupport
extends GuiUtils.PlatformGuiSupport {
    private static final String LIB_NAME = "WinGuiSupport";
    private static boolean loadedOK;

    private static native String nativeGetVersion();

    @Override
    public boolean checkKeyCode(int keyCode) {
        switch (keyCode) {
            case 19: {
                return true;
            }
            case 144: {
                return true;
            }
            case 145: {
                return true;
            }
            case 154: {
                return true;
            }
            case 155: {
                return true;
            }
            case 224: {
                return true;
            }
            case 225: {
                return true;
            }
            case 226: {
                return true;
            }
            case 227: {
                return true;
            }
            case 524: {
                return true;
            }
            case 525: {
                return true;
            }
        }
        return super.checkKeyCode(keyCode);
    }

    @Override
    public boolean hasHotKeys() {
        return loadedOK;
    }

    @Override
    public HotKey createHotKey(int keyCode, int keyModifiers, Runnable action) {
        try {
            return new WinHotKey(keyCode, keyModifiers, action);
        }
        catch (Throwable t) {
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"createHotKey", (String)("Failed to create hot key " + keyCode + "/" + keyModifiers + ":\n" + t));
            }
            return null;
        }
    }

    @Override
    public boolean hasWindowHandles() {
        return loadedOK && WinHandle.isAvailable();
    }

    @Override
    public Object getWindowHandle(Component w) {
        return WinHandle.get(w);
    }

    @Override
    public boolean isDockingSupported() {
        return loadedOK;
    }

    @Override
    public void dockFrame(Frame frame, char mode) {
        WinDock.dockFrame(frame, mode);
    }

    @Override
    public void undockFrame(Frame frame) {
        WinDock.undockFrame(frame);
    }

    static {
        try {
            System.loadLibrary(LIB_NAME);
            LogSupport.message((String)("Loaded native library WinGuiSupport, version " + WindowsGuiSupport.nativeGetVersion()));
            loadedOK = true;
        }
        catch (Throwable t) {
            loadedOK = false;
            LogSupport.message(WindowsGuiSupport.class, (String)"<clinit>", (String)("Failed to load native library: " + Debug.getStackTrace((Throwable)t)));
        }
    }
}

