/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.windows;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

public class WinHandle {
    private static final boolean IS_JAWT_SUPPORTED = true;
    private static final boolean IS_JAWT_WINDOW_SUPPORTED = true;
    private static boolean isAvailable = false;

    private static native void init(String var0);

    private static native long getHWND(Component var0);

    private static native long getHWNDFromTitle(String var0);

    private WinHandle() {
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static Object get(Component c) {
        if (!isAvailable) {
            return null;
        }
        long wndHnd = 0L;
        if (c instanceof Canvas || c instanceof Window) {
            wndHnd = WinHandle.getHWND(c);
            return wndHnd == 0L ? null : new Long(wndHnd);
        }
        String title = null;
        if (c instanceof Frame) {
            title = ((Frame)c).getTitle();
        } else if (c instanceof Dialog) {
            title = ((Dialog)c).getTitle();
        }
        if (title != null && title.length() > 0) {
            wndHnd = WinHandle.getHWNDFromTitle(title);
            return wndHnd == 0L ? null : new Long(wndHnd);
        }
        return null;
    }

    static {
        try {
            WinHandle.init(System.getProperty("java.home"));
            isAvailable = true;
        }
        catch (Throwable t) {
            isAvailable = false;
        }
    }
}

