/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.textparser;

import com.elluminate.gui.textparser.attributeset.HyperlinkAttributeSet;
import com.elluminate.gui.textparser.attributeset.ParsedTextAttributeSet;
import com.elluminate.gui.textparser.attributeset.SmileyAttributeSet;
import com.elluminate.gui.textparser.helper.ParseEvent;
import com.elluminate.gui.textparser.helper.ParseListener;
import com.elluminate.gui.textparser.helper.SmileyPosition;
import com.elluminate.util.I18n;
import com.elluminate.util.net.VClassURI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class TextParser {
    private static I18n i18n = I18n.create(TextParser.class);
    private static final SmileyAttributeSet[] SMILEY_ATTRIBUTES = new SmileyAttributeSet[]{new SmileyAttributeSet(":-)", i18n.getIcon("TextParser.smilies.laughingIcon"), null), new SmileyAttributeSet(":)", i18n.getIcon("TextParser.smilies.laughingIcon"), null), new SmileyAttributeSet(":D", i18n.getIcon("TextParser.smilies.laughingIcon"), null), new SmileyAttributeSet(":S", i18n.getIcon("TextParser.smilies.confusedIcon"), null), new SmileyAttributeSet(":s", i18n.getIcon("TextParser.smilies.confusedIcon"), null), new SmileyAttributeSet(":-o", i18n.getIcon("TextParser.smilies.surpriseIcon"), null), new SmileyAttributeSet(":-O", i18n.getIcon("TextParser.smilies.surpriseIcon"), null), new SmileyAttributeSet(":-0", i18n.getIcon("TextParser.smilies.surpriseIcon"), null), new SmileyAttributeSet(":^)", i18n.getIcon("TextParser.smilies.surpriseIcon"), null), new SmileyAttributeSet(":o", i18n.getIcon("TextParser.smilies.surpriseIcon"), null), new SmileyAttributeSet(":O", i18n.getIcon("TextParser.smilies.surpriseIcon"), null), new SmileyAttributeSet(";-)", i18n.getIcon("TextParser.smilies.winkingIcon"), null), new SmileyAttributeSet(";)", i18n.getIcon("TextParser.smilies.winkingIcon"), null), new SmileyAttributeSet(":-(", i18n.getIcon("TextParser.smilies.sadIcon"), null), new SmileyAttributeSet(":(", i18n.getIcon("TextParser.smilies.sadIcon"), null), new SmileyAttributeSet(":@", i18n.getIcon("TextParser.smilies.angryIcon"), null), new SmileyAttributeSet(":-@", i18n.getIcon("TextParser.smilies.angryIcon"), null)};
    private static final char[] PUNCTUATION_ARRAY = new char[]{'.', ',', ';', ':'};
    private static final ParsedTextAttributeSet LINK_ATTRIBUTES = new HyperlinkAttributeSet(null);
    private EventListenerList listeners = new EventListenerList();
    private DefaultStyledDocument doc;

    public TextParser(DefaultStyledDocument doc) {
        this.doc = doc;
    }

    public void setHyperlinkSelected(boolean isSelected, int offset, String text, AttributeSet attr) {
        if (attr instanceof MutableAttributeSet) {
            if (isSelected) {
                StyleConstants.setForeground((MutableAttributeSet)attr, HyperlinkAttributeSet.SELECTED_COLOR);
            } else {
                StyleConstants.setForeground((MutableAttributeSet)attr, HyperlinkAttributeSet.UNSELECTED_COLOR);
            }
            ParseEvent eventLink = new ParseEvent(this, offset, text.trim(), attr);
            this.fireParseEvent(eventLink);
        }
    }

    public boolean isPotentialHyperlink(String text) {
        String[] linkSchemes = VClassURI.SCHEMES;
        for (int i = 0; i < linkSchemes.length; ++i) {
            if (!text.startsWith(linkSchemes[i])) continue;
            return true;
        }
        return false;
    }

    public List getAllSmileys(String text) {
        ArrayList<SmileyPosition> attrs = new ArrayList<SmileyPosition>();
        for (int i = 0; i < SMILEY_ATTRIBUTES.length; ++i) {
            int smileyIndex = text.indexOf(SMILEY_ATTRIBUTES[i].getTextPattern());
            while (smileyIndex > -1) {
                attrs.add(new SmileyPosition(smileyIndex, SMILEY_ATTRIBUTES[i].getTextPattern(), SMILEY_ATTRIBUTES[i], text));
                smileyIndex = text.indexOf(SMILEY_ATTRIBUTES[i].getTextPattern(), smileyIndex + 1);
            }
        }
        return attrs;
    }

    public String getWordBeforeOffset(String existingText, int offset) {
        String textBefore = existingText.substring(0, offset);
        int lastSeparatorIndexBefore = this.getLastSeparatorIndexBeforeOffset(textBefore);
        String wordBefore = textBefore;
        if (lastSeparatorIndexBefore > -1) {
            wordBefore = textBefore.substring(lastSeparatorIndexBefore + 1);
        }
        return wordBefore;
    }

    public boolean isHyperlinkAttribute(AttributeSet attr) {
        MutableAttributeSet mAttr;
        if (attr instanceof MutableAttributeSet && (mAttr = (MutableAttributeSet)attr).getAttribute("ParsedTextAttributeSet_TextType") != null) {
            return (Integer)mAttr.getAttribute("ParsedTextAttributeSet_TextType") == 1;
        }
        return false;
    }

    public String getWordAfterOffset(String existingText, int offset) {
        String textAfter = existingText.substring(offset);
        int firstSpaceIndexAfter = textAfter.indexOf(" ");
        int firstNewLineIndexAfter = textAfter.indexOf("\n");
        int firstSeparatorIndexAfter = Math.min(firstSpaceIndexAfter, firstNewLineIndexAfter);
        if (firstSpaceIndexAfter == -1 || firstNewLineIndexAfter == -1) {
            firstSeparatorIndexAfter = Math.max(firstSpaceIndexAfter, firstNewLineIndexAfter);
        }
        String wordAfter = textAfter;
        if (firstSeparatorIndexAfter > -1) {
            wordAfter = textAfter.substring(0, firstSeparatorIndexAfter);
        }
        return wordAfter;
    }

    public void normalizeAttributeSet(AttributeSet attr) {
        if (attr instanceof MutableAttributeSet) {
            MutableAttributeSet mAttr = (MutableAttributeSet)attr;
            if (attr.getAttribute("ParsedTextAttributeSet_Default_Color") != null) {
                StyleConstants.setForeground(mAttr, (Color)attr.getAttribute("ParsedTextAttributeSet_Default_Color"));
            }
            if (attr.getAttribute("ParsedTextAttributeSet_Default_Underline") != null) {
                StyleConstants.setUnderline(mAttr, (Boolean)attr.getAttribute("ParsedTextAttributeSet_Default_Underline"));
            }
            mAttr.removeAttribute("ParsedTextAttributeSet_TextType");
            mAttr.removeAttribute("ParsedTextAttributeSet_Default_Color");
            mAttr.removeAttribute("ParsedTextAttributeSet_Default_Icon");
            mAttr.removeAttribute("ParsedTextAttributeSet_Default_Underline");
            mAttr.removeAttribute("SmileyAttributeSet_Pattern");
        }
    }

    public void processMultipleCharacters(int offset, String insertedText, String existingText) throws BadLocationException {
        this.processMultipleCharacters(offset, insertedText, existingText, false);
    }

    public void processMultipleCharacters(int offset, String insertedText, String existingText, boolean forceEvent) throws BadLocationException {
        this.processMultipleCharacters(offset, insertedText, existingText, forceEvent, true);
    }

    public void processMultipleCharacters(int offset, String insertedText, String existingText, boolean forceEvent, boolean doNormalization) throws BadLocationException {
        StringTokenizer st = new StringTokenizer(insertedText, " \n", true);
        int tokenIndex = 0;
        int tokenOffset = offset;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (tokenIndex == 0) {
                String wordBefore = this.getWordBeforeOffset(existingText, offset);
                token = wordBefore + token;
                tokenOffset -= wordBefore.length();
            }
            if (tokenIndex == st.countTokens() - 1) {
                String wordAfter = this.getWordAfterOffset(existingText, offset + insertedText.length());
                token = token + wordAfter;
            }
            if (!this.checkHyperlink(token, tokenOffset, forceEvent) && doNormalization) {
                this.normalize(tokenOffset, tokenOffset + token.length());
            }
            tokenOffset += token.length();
            ++tokenIndex;
        }
    }

    public void normalizeAfterDelete(String existingText, int deleteOffset) throws BadLocationException {
        String wordBefore = this.getWordBeforeOffset(existingText, deleteOffset);
        String wordAfter = this.getWordAfterOffset(existingText, deleteOffset);
        this.normalize(deleteOffset - wordBefore.length(), deleteOffset + wordAfter.length());
    }

    public void addParseListener(ParseListener listener) {
        this.listeners.add(ParseListener.class, listener);
    }

    public static SmileyAttributeSet getSmiley(String pattern) {
        for (int i = 0; i < SMILEY_ATTRIBUTES.length; ++i) {
            if (!SMILEY_ATTRIBUTES[i].getTextPattern().equals(pattern)) continue;
            return SMILEY_ATTRIBUTES[i];
        }
        return null;
    }

    public void removeParseListener(ParseListener listener) {
        this.listeners.remove(ParseListener.class, listener);
    }

    private void fireParseEvent(ParseEvent event) {
        Object[] listenersArray = this.listeners.getListenerList();
        for (int i = listenersArray.length - 2; i >= 0; i -= 2) {
            if (listenersArray[i] != ParseListener.class) continue;
            ((ParseListener)listenersArray[i + 1]).textTypeChanged(event);
        }
    }

    private int getLastSeparatorIndexBeforeOffset(String textBeforeOffset) {
        int lastSpaceIndexBefore = textBeforeOffset.lastIndexOf(" ");
        int lastNewLineIndexBefore = textBeforeOffset.lastIndexOf("\n");
        return Math.max(lastSpaceIndexBefore, lastNewLineIndexBefore);
    }

    private void normalize(int startOffset, int maxOffset) throws BadLocationException {
        ParseEvent eventLink;
        AttributeSet elementAttr;
        String text = this.doc.getText(0, this.doc.getLength());
        Element element = this.doc.getCharacterElement(startOffset);
        int endOffset = element.getEndOffset();
        int lastProcessedEndOffset = startOffset;
        String wordPart = "";
        while (endOffset < maxOffset) {
            wordPart = text.substring(startOffset, endOffset);
            elementAttr = element.getAttributes();
            this.normalizeAttributeSet(elementAttr);
            eventLink = new ParseEvent(this, startOffset, wordPart, elementAttr);
            this.fireParseEvent(eventLink);
            lastProcessedEndOffset = endOffset;
            startOffset = endOffset;
            element = this.doc.getCharacterElement(startOffset);
            endOffset = element.getEndOffset();
        }
        if (lastProcessedEndOffset < maxOffset) {
            wordPart = text.substring(lastProcessedEndOffset, maxOffset);
            elementAttr = element.getAttributes();
            this.normalizeAttributeSet(elementAttr);
            eventLink = new ParseEvent(this, lastProcessedEndOffset, wordPart, elementAttr);
            this.fireParseEvent(eventLink);
        }
    }

    private boolean checkHyperlink(String text, int offset, boolean forceEvent) {
        try {
            ParseEvent eventLink;
            HyperlinkAttributeSet attr;
            AttributeSet elementAttr;
            new VClassURI(text);
            String hyperlink = text;
            text = this.removeEndPunctuationFromHyperlink(hyperlink);
            int maxOffset = offset + text.length();
            int startOffset = offset;
            Element element = this.doc.getCharacterElement(startOffset);
            int endOffset = element.getEndOffset();
            int lastProcessedEndOffset = startOffset;
            String wordPart = "";
            while (endOffset < maxOffset) {
                elementAttr = element.getAttributes();
                if (!this.isHyperlinkAttribute(elementAttr) || forceEvent) {
                    wordPart = text.substring(startOffset - offset, endOffset - offset);
                    attr = (HyperlinkAttributeSet)LINK_ATTRIBUTES.copy(elementAttr);
                    eventLink = new ParseEvent(this, startOffset, wordPart.trim(), attr);
                    this.fireParseEvent(eventLink);
                }
                lastProcessedEndOffset = endOffset;
                startOffset = endOffset;
                element = this.doc.getCharacterElement(startOffset);
                endOffset = element.getEndOffset();
            }
            if (lastProcessedEndOffset < maxOffset && (!this.isHyperlinkAttribute(elementAttr = element.getAttributes()) || forceEvent)) {
                wordPart = text.substring(lastProcessedEndOffset - offset);
                attr = (HyperlinkAttributeSet)LINK_ATTRIBUTES.copy(elementAttr);
                eventLink = new ParseEvent(this, lastProcessedEndOffset, wordPart.trim(), attr);
                this.fireParseEvent(eventLink);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String removeEndPunctuationFromHyperlink(String hyperlink) {
        String hyperlinkFinal = hyperlink;
        for (int i = hyperlink.length() - 1; i >= 0; --i) {
            if (!this.isPunctuation(hyperlink.charAt(i))) {
                return hyperlinkFinal;
            }
            hyperlinkFinal = hyperlinkFinal.substring(0, i);
        }
        return hyperlinkFinal;
    }

    private boolean isPunctuation(char character) {
        if (character == ' ' || character == '\n') {
            return true;
        }
        for (int i = 0; i < PUNCTUATION_ARRAY.length; ++i) {
            if (character != PUNCTUATION_ARRAY[i]) continue;
            return true;
        }
        return false;
    }
}

