/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.gui.component.BadgedIcon;
import com.elluminate.gui.swing.CTable;
import com.elluminate.gui.swing.CTableHeader;
import com.elluminate.gui.swing.TableSorter;
import com.elluminate.platform.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

class IconHeaderRenderer
implements TableCellRenderer {
    private static final Integer ZERO = new Integer(0);
    private static boolean aquaExtendedAPIRetrieved = false;
    private static Method aquaSetSelectedMethod;
    private static Method aquaSetHorizontalShiftMethod;
    private static Method aquaSetSortOrderMethod;
    private static Integer aquaSortNone;
    private static Integer aquaSortAscending;
    private static Integer aquaSortDescending;
    private TableCellRenderer originalRenderer;

    public IconHeaderRenderer(TableCellRenderer originalRenderer) {
        if (originalRenderer == null) {
            throw new IllegalStateException("original renderer can't be null");
        }
        this.originalRenderer = originalRenderer;
        if (Platform.getOS() == 406 && originalRenderer instanceof JComponent) {
            ((JComponent)((Object)originalRenderer)).setPreferredSize(new Dimension(1, 25));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        String text;
        Icon icon;
        Insets ins;
        Icon badge;
        Icon icon2;
        Insets ins2;
        Class<?> clss;
        int alignment;
        Component comp;
        boolean sortOrderShown = false;
        TableSorter sorter = TableSorter.getSorter(table);
        Object headerValue = value;
        String tooltip = null;
        String accessibleName = null;
        if (value instanceof CTableHeader.CTableHeaderValue) {
            tooltip = ((CTableHeader.CTableHeaderValue)value).getTooltip();
            headerValue = ((CTableHeader.CTableHeaderValue)value).getHeaderValue();
            if (headerValue instanceof Accessible) {
                accessibleName = ((Accessible)headerValue).getAccessibleContext().getAccessibleName();
            } else if (headerValue instanceof String) {
                accessibleName = (String)headerValue;
            }
        }
        String compName = (comp = this.originalRenderer.getTableCellRendererComponent(table, headerValue, selected, focused, row, column)).getName() == null ? "" : comp.getName();
        accessibleName = accessibleName == null ? "" : accessibleName;
        AccessibilityUtils.setAccessibleValues((Accessible)((Object)comp), new AccessibilityUtils.AccessibleValues(compName, null, accessibleName, null, tooltip));
        Border brdr = null;
        if (comp instanceof JComponent) {
            brdr = ((JComponent)comp).getBorder();
        }
        boolean leftToRight = comp.getComponentOrientation().isLeftToRight();
        if (table instanceof CTable) {
            alignment = ((CTable)table).getColumnAlignment(column);
            if (alignment == -1) {
                alignment = headerValue instanceof Icon ? 0 : (headerValue instanceof Number ? 4 : 2);
            }
        } else {
            int n = alignment = headerValue instanceof Icon ? 0 : 2;
        }
        if (alignment == 10) {
            alignment = leftToRight ? 2 : 4;
        } else if (alignment == 11) {
            alignment = leftToRight ? 4 : 2;
        }
        int position = alignment == 0 ? 2 : alignment;
        if (brdr != null && (clss = brdr.getClass()).getName().equals("apple.laf.AquaListHeaderBorder")) {
            if (!aquaExtendedAPIRetrieved) {
                IconHeaderRenderer.retrieveAquaExtendedAPI(clss);
            }
            Boolean selectedArg = sorter != null && sorter.getSortColumn() == column ? Boolean.TRUE : Boolean.FALSE;
            Integer sortOrder = null;
            try {
                if (sorter != null && sorter.getSortColumn() == column) {
                    sortOrder = sorter.isAscending() ? aquaSortAscending : aquaSortDescending;
                }
            }
            catch (Throwable t) {
                sortOrder = null;
            }
            Integer hShift = ZERO;
            if (sortOrder == aquaSortAscending || sortOrder == aquaSortDescending) {
                if (alignment == 4) {
                    hShift = new Integer(-14);
                } else if (alignment == 0) {
                    hShift = new Integer(-8);
                }
            }
            if (aquaSetSelectedMethod != null) {
                IconHeaderRenderer.callMethod(aquaSetSelectedMethod, brdr, new Object[]{selectedArg});
            }
            if (aquaSetHorizontalShiftMethod != null) {
                IconHeaderRenderer.callMethod(aquaSetHorizontalShiftMethod, brdr, new Object[]{hShift});
            }
            if (aquaSetSortOrderMethod != null) {
                IconHeaderRenderer.callMethod(aquaSetSortOrderMethod, brdr, new Object[]{sortOrder == null ? aquaSortNone : sortOrder});
                boolean bl = sortOrderShown = sortOrder != null;
            }
        }
        if (comp instanceof JComponent && Platform.getPlatform() == 1 && !Platform.checkJavaVersion((String)"1.5+")) {
            ((JComponent)comp).setPreferredSize(new Dimension(0, 21));
        }
        if (comp instanceof JLabel) {
            JLabel l = (JLabel)comp;
            if (headerValue instanceof Icon) {
                int LEFT_OFFSET = -2;
                l.setHorizontalAlignment(alignment);
                if (brdr instanceof EmptyBorder) {
                    ins2 = brdr.getBorderInsets(l);
                    l.setBorder(BorderFactory.createEmptyBorder(ins2.top, -2, ins2.bottom, 0));
                } else if (brdr != null) {
                    ins2 = brdr.getBorderInsets(l);
                    l.setBorder(BorderFactory.createCompoundBorder(brdr, BorderFactory.createEmptyBorder(0, -2, 0, 0)));
                } else {
                    l.setBorder(BorderFactory.createEmptyBorder(1, -2, 1, 0));
                }
                l.setText(" ");
                l.setHorizontalTextPosition(0);
                icon2 = (Icon)headerValue;
                if (sorter != null && column == sorter.getSortColumn() && !sortOrderShown && (badge = sorter.getHeaderIcon(column)) != null) {
                    int x = icon2.getIconWidth();
                    int y = Math.max(0, icon2.getIconHeight() - badge.getIconHeight());
                    icon2 = new BadgedIcon(icon2, badge, x, y);
                }
                l.setIcon(icon2);
            } else {
                l.setHorizontalAlignment(alignment);
                if (brdr instanceof EmptyBorder) {
                    ins = brdr.getBorderInsets(l);
                    if (ins.left < 4) {
                        l.setBorder(BorderFactory.createEmptyBorder(ins.top, 4, ins.bottom, ins.right));
                    }
                } else if (brdr != null) {
                    ins = brdr.getBorderInsets(l);
                    if (ins.left < 4) {
                        l.setBorder(BorderFactory.createCompoundBorder(brdr, BorderFactory.createEmptyBorder(0, 4 - ins.left, 0, 0)));
                    }
                } else {
                    l.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
                }
                l.setHorizontalTextPosition(position);
                icon = null;
                if (sorter != null && column == sorter.getSortColumn() && !sortOrderShown) {
                    icon = sorter.getHeaderIcon(column);
                }
                l.setIcon(icon);
                if (headerValue == null) {
                    text = " ";
                } else {
                    text = headerValue.toString();
                    if ("".equals(text)) {
                        text = " ";
                    }
                }
                l.setText(text);
            }
        } else if (comp instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)comp;
            if (headerValue instanceof Icon) {
                int LEFT_OFFSET = -2;
                btn.setHorizontalAlignment(alignment);
                if (brdr instanceof EmptyBorder) {
                    ins2 = brdr.getBorderInsets(btn);
                    btn.setBorder(BorderFactory.createEmptyBorder(ins2.top, -2, ins2.bottom, 0));
                } else if (brdr != null) {
                    ins2 = brdr.getBorderInsets(btn);
                    btn.setBorder(BorderFactory.createCompoundBorder(brdr, BorderFactory.createEmptyBorder(0, -2, 0, 0)));
                } else {
                    btn.setBorder(BorderFactory.createEmptyBorder(1, -2, 1, 0));
                }
                btn.setHorizontalTextPosition(0);
                btn.setText(" ");
                icon2 = (Icon)headerValue;
                if (sorter != null && column == sorter.getSortColumn() && !sortOrderShown && (badge = sorter.getHeaderIcon(column)) != null) {
                    int x = icon2.getIconWidth();
                    int y = Math.max(0, icon2.getIconHeight() - badge.getIconHeight());
                    icon2 = new BadgedIcon(icon2, badge, x, y);
                }
                btn.setIcon(icon2);
            } else {
                btn.setHorizontalAlignment(alignment);
                if (brdr instanceof EmptyBorder) {
                    ins = brdr.getBorderInsets(btn);
                    if (ins.left < 4) {
                        btn.setBorder(BorderFactory.createEmptyBorder(ins.top, 4, ins.bottom, ins.right));
                    }
                } else if (brdr != null) {
                    ins = brdr.getBorderInsets(btn);
                    if (ins.left < 4) {
                        btn.setBorder(BorderFactory.createCompoundBorder(brdr, BorderFactory.createEmptyBorder(0, 4 - ins.left, 0, 0)));
                    }
                } else {
                    btn.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
                }
                btn.setHorizontalTextPosition(position);
                icon = null;
                if (sorter != null && column == sorter.getSortColumn() && !sortOrderShown) {
                    icon = sorter.getHeaderIcon(column);
                }
                btn.setIcon(icon);
                if (headerValue == null) {
                    text = " ";
                } else {
                    text = headerValue.toString();
                    if ("".equals(text)) {
                        text = " ";
                    }
                }
                btn.setText(text);
            }
        }
        comp.repaint();
        return comp;
    }

    private static void retrieveAquaExtendedAPI(Class clss) {
        aquaExtendedAPIRetrieved = true;
        aquaSetSelectedMethod = IconHeaderRenderer.findMethod(clss, "setSelected", new Class[]{Boolean.TYPE});
        aquaSetHorizontalShiftMethod = IconHeaderRenderer.findMethod(clss, "setHorizontalShift", new Class[]{Integer.TYPE});
        aquaSetSortOrderMethod = IconHeaderRenderer.findMethod(clss, "setSortOrder", new Class[]{Integer.TYPE});
        Field aquaSortNoneField = IconHeaderRenderer.findField(clss, "kSortNone");
        Field aquaSortAscendingField = IconHeaderRenderer.findField(clss, "kSortAscending");
        Field aquaSortDescendingField = IconHeaderRenderer.findField(clss, "kSortDescending");
        try {
            aquaSortNone = (Integer)aquaSortNoneField.get(null);
            aquaSortAscending = (Integer)aquaSortAscendingField.get(null);
            aquaSortDescending = (Integer)aquaSortDescendingField.get(null);
        }
        catch (Throwable t) {
            aquaSortNone = ZERO;
            aquaSortAscending = null;
            aquaSortDescending = null;
        }
    }

    private static Method findMethod(Class clss, String name, Class[] argTypes) {
        try {
            return clss.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Field findField(Class clss, String name) {
        try {
            return clss.getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static void callMethod(Method method, Object obj, Object[] args) {
        try {
            method.invoke(obj, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

