/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.platform.Platform;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class CTree
extends JTree {
    private boolean renderersHaveToolTips = false;
    private boolean addClearSelectionListener = true;

    public CTree() {
        this.init();
    }

    public CTree(Hashtable value) {
        super(value);
        this.init();
    }

    public CTree(Object[] value) {
        super(value);
        this.init();
    }

    public CTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public CTree(TreeNode root) {
        super(root);
        this.init();
    }

    public CTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public CTree(Vector value) {
        super(value);
        this.init();
    }

    public void setRenderersHaveToolTips(boolean renderersHaveToolTips) {
        if (this.renderersHaveToolTips == renderersHaveToolTips) {
            return;
        }
        this.renderersHaveToolTips = renderersHaveToolTips;
        if (this.getToolTipText() == null) {
            if (this.renderersHaveToolTips) {
                ToolTipManager.sharedInstance().registerComponent(this);
            } else {
                ToolTipManager.sharedInstance().unregisterComponent(this);
            }
        }
    }

    public boolean isRenderersHaveToolTips() {
        return this.renderersHaveToolTips;
    }

    @Override
    public void setToolTipText(String text) {
        if (this.renderersHaveToolTips) {
            this.putClientProperty("ToolTipText", text);
        } else {
            super.setToolTipText(text);
        }
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        String tip = super.getToolTipText(ev);
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    public void expandExposed() {
        for (int rx = this.getRowCount() - 1; rx >= 0; --rx) {
            if (this.isExpanded(rx)) continue;
            this.expandRow(rx);
        }
    }

    public void expandAll() {
        for (int rx = 0; rx < this.getRowCount(); ++rx) {
            if (this.isExpanded(rx)) continue;
            this.expandRow(rx);
        }
    }

    public void collapseAll() {
        for (int rx = this.getRowCount() - 1; rx >= 0; --rx) {
            if (this.isCollapsed(rx)) continue;
            this.collapseRow(rx);
        }
    }

    private void init() {
        this.addMouseListener(new ClearSelectionMouseAdapter());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            Border brdr;
            JScrollPane scrollPane = (JScrollPane)gp;
            if (Platform.getLAF() == 502 && (brdr = scrollPane.getBorder()) instanceof UIResource) {
                scrollPane.setBackground(null);
                scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), brdr));
            }
        }
    }

    public class ClearSelectionMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent e) {
            Point pt = e.getPoint();
            if (CTree.this.getRowForLocation(pt.x, pt.y) == -1) {
                CTree.this.clearSelection();
            }
        }
    }
}

