/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.ModalDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class CFileChooser
extends JFileChooser {
    private static final int REFRESH_PERIOD = 2000;
    private static final boolean isMac = Platform.getPlatform() == 2;
    private static final boolean isWin = Platform.getPlatform() == 1;
    private boolean enableRefresh = true;
    private boolean metalDelegateInstalled = false;

    public CFileChooser() {
    }

    public CFileChooser(File curDir) {
        super(curDir);
    }

    public CFileChooser(File curDir, FileSystemView fsv) {
        super(curDir, fsv);
    }

    public CFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public CFileChooser(String curDir) {
        super(curDir);
    }

    public CFileChooser(String curDir, FileSystemView fsv) {
        super(curDir, fsv);
    }

    public boolean isRefreshEnabled() {
        return this.enableRefresh;
    }

    public void setRefreshEnabled(boolean b) {
        this.enableRefresh = b;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        try {
            if (isWin && GUIDebug.METAL_CHOOSER.show()) {
                throw new RuntimeException("Testing Metal FileChooserUI hack");
            }
            super.setUI(newUI);
        }
        catch (RuntimeException rtx) {
            if (!isWin) {
                throw rtx;
            }
            LogSupport.message((Object)this, (String)"setUI", (String)("Failed to install FileChooserUI " + newUI + ": " + Debug.getStackTrace((Throwable)rtx)));
            LogSupport.message((Object)this, (String)"setUI", (String)"Falling back to Java PLAF.");
            if (!this.metalDelegateInstalled) {
                UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
                this.metalDelegateInstalled = true;
            }
            try {
                super.setUI(null);
            }
            catch (Throwable t) {
                this.ui = null;
            }
            try {
                super.setUI(new MetalFileChooserUI(this));
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"setUI", (Throwable)t, (boolean)true, (String)"Failed to install Java PLAF FileChooserUI");
                throw rtx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showDialog(Component parent, String approveButtonText) {
        LightweightTimer refreshTimer = null;
        try {
            boolean returnVal = true;
            if (this.enableRefresh && !isMac) {
                Runnable refreshAction = new Runnable(){

                    @Override
                    public void run() {
                        CFileChooser.this.rescanCurrentDirectory();
                    }
                };
                refreshTimer = new LightweightTimer(2, refreshAction);
                refreshTimer.scheduleEvery(2000L);
            }
            int n = super.showDialog(parent, approveButtonText);
            return n;
        }
        finally {
            if (refreshTimer != null) {
                refreshTimer.cancel();
            }
        }
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        ModalDialog.positionWindow(dialog, parent);
        return dialog;
    }
}

