/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.net;

import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.net.StringsProperties;
import com.elluminate.gui.swing.CPasswordField;
import com.elluminate.net.ProxyAuthContext;
import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.ProxyAuthDataProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class DlgProxyAuthDataProvider
implements ProxyAuthDataProvider {
    private I18n i18n = I18n.create((Object)this);
    private Component parent = null;
    private LinkedList<Request> queue = new LinkedList();
    private Request active = null;

    public DlgProxyAuthDataProvider(Component parent) {
        this.parent = parent;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        LinkedList<Request> linkedList = this.queue;
        synchronized (linkedList) {
            for (Request req : this.queue) {
                req.abort();
            }
            if (this.active != null) {
                this.active.abort();
            }
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getProxyAuthData(ProxyAuthData data) {
        Request req = new Request(data);
        boolean result = false;
        LinkedList<Request> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(req);
            while (this.queue.getFirst() != req) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException ex) {
                    this.queue.remove(req);
                    this.queue.notifyAll();
                    return false;
                }
                if (!req.isAborted()) continue;
                this.queue.remove(req);
                this.queue.notifyAll();
                return false;
            }
            this.active = this.queue.removeFirst();
        }
        result = this.active.execute();
        linkedList = this.queue;
        synchronized (linkedList) {
            this.active = null;
            this.queue.notifyAll();
        }
        return result;
    }

    private class Request {
        private JDialog dialog = null;
        private ProxyAuthData data = null;
        private boolean aborted = false;

        public Request(ProxyAuthData data) {
            this.data = data;
        }

        public void abort() {
            this.aborted = true;
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public boolean execute() {
            ProxyAuthContext context = this.data.getContext();
            JTextField realm = new JTextField();
            realm.setEnabled(context.isWritable());
            realm.setText(context.getValue());
            JTextField user = new JTextField();
            user.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
            CPasswordField pass = new CPasswordField();
            pass.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
            Object[] message = new Object[]{context.getLabel(), realm, DlgProxyAuthDataProvider.this.i18n.getString((PropertiesEnum)StringsProperties.DLGPROXYAUTHDATAPROVIDER_USERPROMPT), user, DlgProxyAuthDataProvider.this.i18n.getString((PropertiesEnum)StringsProperties.DLGPROXYAUTHDATAPROVIDER_PASSPROMPT), pass};
            JOptionPane pane = new JOptionPane(message, 3, 2, null, null, null);
            if (this.aborted) {
                return false;
            }
            ModalDialog.showCustomDialog(DlgProxyAuthDataProvider.this.parent, pane, DlgProxyAuthDataProvider.this.i18n.getString((PropertiesEnum)StringsProperties.DLGPROXYAUTHDATAPROVIDER_TITLE), user, false);
            int option = -1;
            Object selectedValue = pane.getValue();
            if (selectedValue instanceof Integer) {
                option = (Integer)selectedValue;
            }
            if (option == 0) {
                String uName = user.getText();
                char[] pwChr = pass.getPassword();
                if (context.isWritable()) {
                    String cName = realm.getText();
                    this.data.setContextName(cName);
                }
                this.data.setAuthData(uName, new String(pwChr));
                return true;
            }
            return false;
        }
    }
}

