/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.macosx;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.gui.macosx.CarbonHotKeyManager;
import com.elluminate.gui.macosx.MacGuiSupport;
import com.elluminate.platform.MacOSXPlatform;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.event.KeyEvent;

public final class CarbonHotKey
implements HotKey {
    private static final String JNI_LIB_NAME = "macguisupport";
    private static MacOSXPlatform.CarbonLock carbonLock = MacOSXPlatform.getCarbonLock();
    private static final String vClassSignatureStr = "vCls";
    private static final long vClassSignature = MacOSXPlatform.convertFileType((String)"vCls");
    private static final SerializerThread actionThread = new SerializerThread("HotKey Action Thread");
    private static boolean loadedOK = false;
    private Runnable action = null;
    private boolean enabledFlag = false;
    private long hotKeyRef = 0L;
    private int javaKeyCode = 0;
    private int javaKeyMod = 0;
    private int carbonKeyCode = 0;
    private int carbonKeyMod = 0;
    private long id = 0L;

    public static boolean isLoadedOK() {
        return loadedOK;
    }

    public CarbonHotKey(int keyCode, int modifiers, Runnable anAction) {
        if (!loadedOK) {
            throw new RuntimeException("CarbonHotKey failed to load correctly, hot keys unavailable.");
        }
        if (!CarbonHotKeyManager.loadedOK()) {
            throw new RuntimeException("CarbonHotKeyManager failed to load correctly, hot keys unavailable.");
        }
        this.javaKeyCode = keyCode;
        this.javaKeyMod = modifiers;
        this.action = anAction;
        this.id = vClassSignature << 32 | (long)this.hashCode();
        int err = this.registerHotKey();
        if (err != 0) {
            throw new RuntimeException("Mac error " + err + " registering hot key: " + Long.toHexString(this.getUniqueID()) + " (key=" + keyCode + ", mod=" + modifiers + ")");
        }
        this.enabledFlag = true;
        if (GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"<init>", (String)("Registered hot key: ID=" + Long.toHexString(this.getUniqueID()) + " key=" + (modifiers != 0 ? KeyEvent.getKeyModifiersText(modifiers) + "+" : "") + KeyEvent.getKeyText(keyCode) + " (CarbonKey=" + this.carbonKeyCode + " CarbonMod=" + this.carbonKeyMod + ")"));
        }
    }

    @Override
    public int getKeyCode() {
        return this.javaKeyCode;
    }

    @Override
    public int getModifiers() {
        return this.javaKeyMod;
    }

    @Override
    public String getKeyDesc() {
        return GuiUtils.getKeystrokeText(this.javaKeyCode, this.javaKeyMod);
    }

    @Override
    public boolean hasAction() {
        return this.action != null;
    }

    @Override
    public void setAction(Runnable anAction) {
        this.action = anAction;
    }

    @Override
    public void runAction() {
        this.execute();
    }

    @Override
    public boolean isEnabled() {
        return this.enabledFlag;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabledFlag = enabled;
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed();
    }

    @Override
    public void dispose() {
        this.unregisterHotKey();
    }

    @Override
    public boolean isDisposed() {
        return this.hotKeyRef == 0L;
    }

    public long getUniqueID() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getName() + ": " + "key=" + KeyEvent.getKeyText(this.javaKeyCode) + " mod=" + KeyEvent.getKeyModifiersText(this.javaKeyMod) + " id=" + Long.toHexString(this.getUniqueID()) + " enabled=" + this.enabledFlag + " action=" + (this.action == null ? "NONE" : this.action.toString());
    }

    private void execute() {
        if (this.enabledFlag && this.action != null) {
            actionThread.invokeLater(this.action);
        }
    }

    protected int registerHotKey() {
        this.carbonKeyCode = MacGuiSupport.translateKeyCode(this.javaKeyCode);
        this.carbonKeyMod = MacGuiSupport.translateModifier(this.javaKeyMod);
        if (this.carbonKeyCode == -1 || this.carbonKeyMod == -1) {
            LogSupport.message((Object)this, (String)"registerHotKey", (String)("No carbon key mapping: key=" + KeyEvent.getKeyText(this.javaKeyCode) + "=" + Integer.toHexString(this.javaKeyCode) + " mod=" + KeyEvent.getKeyModifiersText(this.javaKeyMod) + "=" + Integer.toHexString(this.javaKeyMod)));
            return -2;
        }
        int err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = 0;

            public void run() {
                block3: {
                    try {
                        long[] tmpRef = new long[]{0L};
                        this.result = CarbonHotKey.carbonRegisterEventHotKey(CarbonHotKey.this.carbonKeyCode, CarbonHotKey.this.carbonKeyMod, CarbonHotKey.this.getUniqueID(), tmpRef);
                        if (this.result != 0) {
                            return;
                        }
                        CarbonHotKey.this.hotKeyRef = tmpRef[0];
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)((Object)this), (String)"run", (Throwable)t, (boolean)true);
                        if (this.result != 0) break block3;
                        this.result = -1;
                    }
                }
            }

            public int intResult() {
                return this.result;
            }
        });
        if (err == 0) {
            CarbonHotKeyManager.registerHotKey(this);
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"registerHotKey", (String)("Created hot key: " + this.toString()));
            }
        } else if (GUIDebug.HOT_KEYS.show() && err != -1) {
            if (err == -9878) {
                LogSupport.message((Object)this, (String)"registerHotKey", (String)"Hot key already in use by this process.");
            } else {
                LogSupport.message((Object)this, (String)"registerHotKey", (String)("MacOS error in RegisterEventHotKey: " + err));
            }
        }
        return err;
    }

    protected void unregisterHotKey() {
        if (this.hotKeyRef == 0L) {
            return;
        }
        CarbonHotKeyManager.unregisterHotKey(this);
        int err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = 0;

            public void run() {
                block3: {
                    try {
                        if (CarbonHotKey.this.hotKeyRef != 0L) {
                            long tmp = CarbonHotKey.this.hotKeyRef;
                            CarbonHotKey.this.hotKeyRef = 0L;
                            this.result = CarbonHotKey.carbonUnregisterEventHotKey(tmp);
                        }
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)((Object)this), (String)"run", (Throwable)t, (boolean)true);
                        if (this.result != 0) break block3;
                        this.result = -1;
                    }
                }
            }

            public int intResult() {
                return this.result;
            }
        });
        if (err != 0) {
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"unregisterHotKey", (String)("MacOS error in UnregisterEventHotKey: " + err));
            }
        } else if (GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"unregisterHotKey", (String)("De-registered hot key: " + this.toString()));
        }
    }

    private static int findKeyCode(String name) {
        try {
            return KeyEvent.class.getField(name).getInt(null);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static boolean checkAlias(int a, int b) {
        if (a == 0) {
            return false;
        }
        if (b == 0) {
            return false;
        }
        return MacGuiSupport.translateKeyCode(a) == MacGuiSupport.translateKeyCode(b);
    }

    static native int getHotKeysVersionNative();

    static native void setDebugIONative(boolean var0);

    static native int carbonCallNextEventHandler(long var0, long var2);

    static native int carbonGetEventParameter(long var0, int var2, int var3, int var4, byte[] var5);

    static native int carbonGetEventParameterHotKeyID(long var0, int var2, long[] var3);

    static native int carbonInstallEventHandler(CarbonEventHandlerInterface var0, int var1, int var2, int var3, long[] var4);

    static native int carbonRemoveEventHandler(long var0);

    static native int carbonRegisterEventHotKey(int var0, int var1, long var2, long[] var4);

    static native int carbonUnregisterEventHotKey(long var0);

    static {
        System.loadLibrary(JNI_LIB_NAME);
        int vers = CarbonHotKey.getHotKeysVersionNative();
        loadedOK = true;
        LogSupport.message((String)("Loaded native library macguisupport, version " + (vers >> 16 & 0xFFFF) + "." + (vers >> 8 & 0xFF) + "." + (vers & 0xFF)));
    }

    public static interface CarbonEventHandlerInterface {
        public int carbonEventHandler(long var1, long var3, int var5);
    }
}

