/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.dnd;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.dnd.DropHelperInterface;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataFlavorManager {
    private Map<DataFlavor, DropHelperInterface> dataFlavors = new HashMap<DataFlavor, DropHelperInterface>();
    private PriorityMap priorityMap = new PriorityMap();

    public void setDataFlavorsMap(Map<DataFlavor, DropHelperInterface> dataFlavors) {
        this.dataFlavors = dataFlavors;
    }

    public Map<DataFlavor, DropHelperInterface> getDataFlavorsMap() {
        return this.dataFlavors;
    }

    public Set<DataFlavor> getDataFlavors() {
        return this.dataFlavors.keySet();
    }

    public Collection<DropHelperInterface> getDropHelpers() {
        return this.dataFlavors.values();
    }

    public void addDataFlavor(DataFlavor df, DropHelperInterface dropHelper, int priority) {
        this.dataFlavors.put(df, dropHelper);
        if (priority > 0) {
            PrioritizedDataFlavor pdf = new PrioritizedDataFlavor(df.getMimeType(), df.getHumanPresentableName(), priority);
            this.priorityMap.put(new Integer(priority), pdf);
        }
    }

    public void removeDataFlavor(DataFlavor dataFlavor) {
        this.dataFlavors.remove(dataFlavor);
    }

    public DropHelperInterface getDropHelper(DataFlavor dataFlavor) {
        return this.dataFlavors.get(dataFlavor);
    }

    public boolean isFlavorSupported(Transferable content) {
        try {
            List<DataFlavor> incomingDataFlavors = Arrays.asList(content.getTransferDataFlavors());
            for (DataFlavor df : this.getDataFlavors()) {
                if (!incomingDataFlavors.contains(df)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"chooseBestFlavor", (Throwable)ex, (boolean)true);
            return false;
        }
    }

    public DataFlavor chooseBestFlavor(Transferable content) {
        try {
            if (this.priorityMap.isEmpty()) {
                return this.chooseBestFlavor(content, this.dataFlavors.keySet());
            }
            List<Integer> priorityKeys = this.priorityMap.getSortedKeys();
            for (Integer key : priorityKeys) {
                DataFlavor df;
                if (GUIDebug.DATA_FLAVORS.show()) {
                    LogSupport.message((Object)this, (String)"chooseBestFlavor", (String)("Processing flavours of priority " + key));
                }
                if ((df = this.chooseBestFlavor(content, (List)this.priorityMap.get(key))) == null) continue;
                return df;
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"chooseBestFlavor", (Throwable)ex, (boolean)true);
            return null;
        }
        return null;
    }

    private DataFlavor chooseBestFlavor(Transferable content, Collection<DataFlavor> targetFlavors) {
        DataFlavor[] incomingFlavors = content.getTransferDataFlavors();
        for (DataFlavor cur : targetFlavors) {
            if (GUIDebug.DATA_FLAVORS.show()) {
                LogSupport.message((Object)this, (String)"chooseBestFlavor", (String)("Checking incoming flavours for: " + cur.getMimeType() + " " + cur.getHumanPresentableName()));
            }
            for (int i = 0; i < incomingFlavors.length; ++i) {
                if (!cur.equals(incomingFlavors[i])) continue;
                try {
                    content.getTransferData(incomingFlavors[i]);
                }
                catch (Throwable t) {
                    if (GUIDebug.DATA_FLAVORS.show()) {
                        LogSupport.message((Object)this, (String)"chooseBestFlavor", (String)("Error getting DataFlavor from Transferable: " + Debug.getStackTrace((Throwable)t)));
                        continue;
                    }
                    LogSupport.message((Object)this, (String)"chooseBestFlavor", (String)("Error getting DataFlavor from Transferable: " + t));
                    continue;
                }
                if (GUIDebug.DATA_FLAVORS.show()) {
                    LogSupport.message((Object)this, (String)"chooseBestFlavor", (String)("  *** matched at " + i + ": " + incomingFlavors[i]));
                }
                return incomingFlavors[i];
            }
        }
        return null;
    }

    class PrioritizedDataFlavor
    extends DataFlavor {
        private int priority;

        public PrioritizedDataFlavor(String mimeType, String humanPresentableName, int priority) {
            super(mimeType, humanPresentableName);
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }
    }

    private class PriorityMap
    extends HashMap {
        private PriorityMap() {
        }

        @Override
        public Object put(Integer key, PrioritizedDataFlavor value) {
            ArrayList<PrioritizedDataFlavor> listToAddTo = (ArrayList<PrioritizedDataFlavor>)this.get(key);
            if (listToAddTo == null) {
                listToAddTo = new ArrayList<PrioritizedDataFlavor>();
            }
            listToAddTo.add(value);
            return super.put(key, listToAddTo);
        }

        @Override
        public Object put(Object key, Object value) {
            if (key instanceof Integer && value instanceof PrioritizedDataFlavor) {
                return this.put((Integer)key, (PrioritizedDataFlavor)value);
            }
            return null;
        }

        public List<Integer> getSortedKeys() {
            ArrayList<Integer> toSort = new ArrayList<Integer>(this.keySet());
            Collections.sort(toSort);
            return toSort;
        }
    }
}

