/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.FontUtils;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;

public class TimerFormattedTextField
extends JFormattedTextField {
    public static final int TIMER_EDIT_FIELD_EXTRA_WIDTH = 12;
    private String mask = "##:##:##";
    protected static final String datePattern = "HH:mm:ss";
    public DateVerifier objDateVerifier;
    private int fontSize;
    private int fontStyle;

    public TimerFormattedTextField() {
        this.getMaskFormatter();
        this.setFocusLostBehavior(3);
        this.objDateVerifier = new DateVerifier();
        this.setInputVerifier(this.objDateVerifier);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TimerFormattedTextField.this.getMaskFormatter();
            }
        });
    }

    public TimerFormattedTextField(Font font, int fontSize, int fontStyle) throws ParseException {
        this();
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.setFont(FontUtils.setFontStyleAndSize(font, fontStyle, fontSize));
    }

    public long getTotalSeconds() throws Exception {
        String currText = (String)this.getValue();
        String[] timeValues = currText.split(":");
        if (timeValues.length != 3) {
            throw new Exception("Invalid Time Value in found");
        }
        int hours = Integer.parseInt(timeValues[0]);
        int minutes = Integer.parseInt(timeValues[1]);
        int seconds = Integer.parseInt(timeValues[2]);
        return hours * 3600 + minutes * 60 + seconds;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.setFont(FontUtils.setFontStyleAndSize(this.getFont(), this.fontStyle, fontSize));
    }

    public void setValue(long totalNumberOfSeconds) {
        int hr = 0;
        int min = 0;
        int sec = 0;
        long hourDivisor = 3600L;
        hr = (int)(totalNumberOfSeconds / hourDivisor);
        min = (int)((totalNumberOfSeconds %= hourDivisor) / 60L);
        sec = (int)(totalNumberOfSeconds % 60L);
        this.setValue(hr, min, sec);
    }

    private void setValue(int hr, int min, int sec) {
        this.setValue(this.zeroPadNumberString(hr, 2) + ":" + this.zeroPadNumberString(min, 2) + ":" + this.zeroPadNumberString(sec, 2));
    }

    private String zeroPadNumberString(int num, int strLen) {
        String result = String.valueOf(num);
        if (num < 10) {
            for (int i = 1; i < strLen; ++i) {
                result = "0" + result;
            }
        }
        return result;
    }

    public boolean getDateVerifier(boolean p_isPopupErrorEnable) {
        return this.objDateVerifier.verify(this, p_isPopupErrorEnable);
    }

    @Override
    public Object getValue() {
        if (super.getValue() != null) {
            return super.getValue();
        }
        if (!super.getText().equals("__:__:__")) {
            return super.getText();
        }
        return null;
    }

    public MaskFormatter getMaskFormatter() {
        MaskFormatter objMask = new MaskFormatter();
        try {
            objMask.setMask(this.mask);
            objMask.setPlaceholderCharacter('_');
            objMask.install(this);
        }
        catch (ParseException pe) {
            System.out.println("Exception " + pe);
        }
        return objMask;
    }

    class DateVerifier
    extends InputVerifier {
        private boolean isPopupErrorEnable = true;

        DateVerifier() {
        }

        private boolean isDateValid(String p_Date) {
            try {
                Pattern p = Pattern.compile("(0?[0-9]|[1-9][0-9])[:](0?[0-9]|[1-5][0-9])[:](0?[0-9]|[1-5][0-9])");
                Matcher m = p.matcher(this.sanitizeTime(p_Date));
                return m.matches();
            }
            catch (Exception dfe) {
                System.out.println("Invalid time");
                return false;
            }
        }

        private String sanitizeTime(String time) {
            return time.replaceAll("_", "");
        }

        public boolean verify(JComponent input, boolean p_isPopupErrorEnable) {
            this.isPopupErrorEnable = p_isPopupErrorEnable;
            boolean result = this.verify(input);
            this.isPopupErrorEnable = true;
            return result;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                if (input instanceof JFormattedTextField) {
                    JFormattedTextField jtf = (JFormattedTextField)input;
                    if (jtf.getText() == null || jtf.getText().equalsIgnoreCase("__:__:__") || jtf.getText().equalsIgnoreCase("") || jtf.getText().length() == 0) {
                        jtf.setValue(null);
                        jtf.commitEdit();
                        ((TimerFormattedTextField)jtf).getMaskFormatter();
                        return true;
                    }
                    if (this.isDateValid(jtf.getText())) {
                        try {
                            jtf.setValue(this.sanitizeTime(jtf.getText()));
                            jtf.commitEdit();
                            return true;
                        }
                        catch (ParseException e) {
                            if (this.isPopupErrorEnable) {
                                JOptionPane.showMessageDialog(jtf.getParent(), "Invalid Time, Please Try with HH:mm:ss Format", "Date Error..", 0);
                            }
                            jtf.commitEdit();
                            jtf.selectAll();
                            return false;
                        }
                    }
                    if (this.isPopupErrorEnable) {
                        JOptionPane.showMessageDialog(input.getParent(), "Invalid Time, Please Try with HH:mm:ss Format", "Date Error..", 0);
                    }
                    jtf.selectAll();
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

