/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.swing.CPopupMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class ScrollPopUp
extends CPopupMenu {
    private ScrollablePopUpItem lastSelected;
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel menuList = new JPanel();
    private int indexCount;
    private GridBagConstraints gbc = new GridBagConstraints();

    public ScrollPopUp() {
        this.scrollPane.setViewportView(this.menuList);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(null);
        this.menuList.setLayout(new GridLayout(0, 1));
        this.gbc.fill = 2;
        this.add(this.scrollPane);
    }

    public Component add(String itemText, ActionListener listener) {
        JButton b = this.addString(itemText);
        b.addActionListener(listener);
        return b;
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] components = this.menuList.getComponents();
        Dimension d = new Dimension();
        for (int i = 0; i < components.length; ++i) {
            if (components[i].getPreferredSize().width > d.width) {
                d.width = components[i].getPreferredSize().width;
            }
            d.height += components[i].getPreferredSize().height;
        }
        d.height += 8;
        d.width += 30;
        d.height = Math.min(d.height, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
        return d;
    }

    @Override
    public void setSelected(Component selection) {
        if (selection instanceof ScrollablePopUpItem) {
            ((ScrollablePopUpItem)selection).setSelected(true);
        }
    }

    @Override
    public void removeAll() {
        this.menuList.removeAll();
        this.lastSelected = null;
    }

    @Override
    @Deprecated
    public JMenuItem add(JMenuItem menuItem) {
        throw new UnsupportedOperationException("Can not use JMenuItem with ScrollPopUp, tried it, doesn't work.");
    }

    private void selected(ScrollablePopUpItem selected) {
        if (this.lastSelected != null && this.lastSelected != selected) {
            this.lastSelected.setSelected(false);
        }
        this.scrollPane.getViewport().scrollRectToVisible(selected.getBounds());
        this.lastSelected = selected;
    }

    private void add(JButton button) {
        button.setSelected(false);
        this.menuList.add((Component)button, this.gbc);
    }

    private JButton addString(String s) {
        ScrollablePopUpItem b = new ScrollablePopUpItem(this);
        b.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        b.setText(s);
        b.setHorizontalAlignment(2);
        this.add(b);
        return b;
    }

    private static final class ScrollablePopUpItem
    extends JButton {
        private final Color FG_COLOR = UIManager.getColor("MenuItem.foreground");
        private final Color BG_COLOR = UIManager.getColor("MenuItem.background");
        private final Color SELECTED_FG_COLOR = UIManager.getColor("MenuItem.selectionForeground");
        private final Color SELECTED_BG_COLOR = UIManager.getColor("MenuItem.selectionBackground");
        private ScrollPopUp parent;

        ScrollablePopUpItem(ScrollPopUp parent) {
            this.setUI(BasicButtonUI.createUI(this));
            this.addMouseListener(this.createMouseListener());
            this.parent = parent;
        }

        private MouseListener createMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent arg0) {
                    ScrollablePopUpItem.this.setSelected(true);
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                    ScrollablePopUpItem.this.setSelected(false);
                }
            };
        }

        @Override
        public void setSelected(boolean selected) {
            super.setSelected(selected);
            if (selected) {
                this.setColors(this.SELECTED_FG_COLOR, this.SELECTED_BG_COLOR);
                this.parent.selected(this);
            } else {
                this.setColors(this.FG_COLOR, this.BG_COLOR);
            }
        }

        private void setColors(Color fg, Color bg) {
            this.setForeground(fg);
            this.setBackground(bg);
        }
    }
}

