/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;

public class RollOverBehavior
implements MouseListener,
ItemListener {
    private static final String INSTALLED_PROP = "com.elluminate.gui.RollOverBehavior.installed";
    private boolean buttonWasFocusable = false;
    private boolean borderWasPainted = false;
    private boolean contentAreaWasFilled = false;
    private boolean buttonWasOpaque = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(AbstractButton button) {
        Class<RollOverBehavior> clazz = RollOverBehavior.class;
        synchronized (RollOverBehavior.class) {
            if (button.getClientProperty(INSTALLED_PROP) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            RollOverBehavior listener = new RollOverBehavior();
            listener.installOnButton(button);
            button.putClientProperty(INSTALLED_PROP, listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(AbstractButton button) {
        Class<RollOverBehavior> clazz = RollOverBehavior.class;
        synchronized (RollOverBehavior.class) {
            RollOverBehavior listener = null;
            try {
                listener = (RollOverBehavior)button.getClientProperty(INSTALLED_PROP);
            }
            catch (Throwable t) {
                listener = null;
            }
            if (listener == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            listener.removeFromButton(button);
            button.putClientProperty(INSTALLED_PROP, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(AbstractButton button) {
        Class<RollOverBehavior> clazz = RollOverBehavior.class;
        synchronized (RollOverBehavior.class) {
            RollOverBehavior listener = null;
            try {
                listener = (RollOverBehavior)button.getClientProperty(INSTALLED_PROP);
            }
            catch (Throwable t) {
                listener = null;
            }
            if (listener != null) {
                listener.applyBorder(button, false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private RollOverBehavior() {
    }

    private void installOnButton(AbstractButton button) {
        this.buttonWasFocusable = button.isFocusable();
        this.borderWasPainted = button.isBorderPainted();
        this.contentAreaWasFilled = button.isContentAreaFilled();
        this.buttonWasOpaque = button.isOpaque();
        button.setOpaque(false);
        button.addMouseListener(this);
        button.addItemListener(this);
        this.applyBorder(button, false);
    }

    private void removeFromButton(AbstractButton button) {
        button.removeMouseListener(this);
        button.removeItemListener(this);
        button.setFocusable(this.buttonWasFocusable);
        button.setBorderPainted(this.borderWasPainted);
        button.setContentAreaFilled(this.contentAreaWasFilled);
        button.setOpaque(this.buttonWasOpaque);
    }

    private void applyBorder(AbstractButton button, boolean hovering) {
        if (hovering || button.isSelected()) {
            button.setBorderPainted(true);
            button.setContentAreaFilled(true);
        } else {
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        if (button.isEnabled() && !button.isSelected()) {
            this.applyBorder(button, true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        if (!button.isSelected()) {
            this.applyBorder(button, false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        this.applyBorder(button, false);
    }
}

