/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ProgressWheelUI
extends BasicProgressBarUI {
    private static final int ANIMATION_STEP_COUNT = 30;
    private int animationFrameCount;
    private int lastStepIndex;
    private BufferedImage cachedRendering;

    public static ComponentUI createUI(JComponent c) {
        return new ProgressWheelUI();
    }

    @Override
    protected void installDefaults() {
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.TRUE);
        LookAndFeel.installColors(this.progressBar, "ProgressBar.background", "ProgressBar.foreground");
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        return null;
    }

    @Override
    protected void startAnimationTimer() {
        int cycle = UIManager.getInt("ProgressBar.cycleTime");
        int interval = UIManager.getInt("ProgressBar.repaintInterval");
        this.animationFrameCount = cycle / interval;
        super.startAnimationTimer();
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        int stepIndex = 30 - 30 * this.getAnimationIndex() / this.animationFrameCount;
        if (stepIndex != this.lastStepIndex) {
            this.cachedRendering = null;
        }
        if (this.cachedRendering == null) {
            Dimension s = c.getSize();
            this.cachedRendering = new BufferedImage(s.width, s.height, 2);
            Graphics2D g2 = (Graphics2D)this.cachedRendering.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(c.getForeground());
            g2.setStroke(new BasicStroke(1.5f));
            g2.drawArc(1, 1, s.width - 3, s.height - 3, stepIndex * 360 / 30, 135);
            g2.drawArc(1, 1, s.width - 3, s.height - 3, (stepIndex + 15) * 360 / 30, 135);
            g2.dispose();
        }
        g.drawImage(this.cachedRendering, 0, 0, c);
        this.lastStepIndex = stepIndex;
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        JProgressBar wheel = (JProgressBar)c;
        Dimension s = wheel.getSize();
        int min = wheel.getMinimum();
        int max = wheel.getMaximum();
        int val = wheel.getValue();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(c.getForeground());
        g2.setStroke(new BasicStroke(1.5f));
        g2.drawOval(1, 1, s.width - 3, s.height - 3);
        if (val > min) {
            int a = 360 * (val - min) / (max - min);
            g2.fillArc(1, 1, s.width - 3, s.height - 3, 90, -a);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(16, 16);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }
}

