/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.GuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class MultilineLabel
extends JTextArea
implements Accessible {
    private Component labelTarget = null;

    public MultilineLabel() {
        this.setEditable(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.setBackground(UIManager.getColor("Label.background"));
    }

    public MultilineLabel(String text) {
        this();
        this.setText(text);
    }

    public MultilineLabel(String text, int maxWidth) {
        this();
        this.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        } else {
            this.getAccessibleContext();
        }
        super.setText(text);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != oldAccessibleName) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
        this.setLineWrap(false);
        this.setWrapStyleWord(false);
        this.setSize(Math.min(this.getPreferredSize().width, this.getMaximumSize().width), Integer.MAX_VALUE);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Label.background"));
        this.setFont(UIManager.getFont("Label.font"));
    }

    public Component getLabelFor() {
        return this.labelTarget;
    }

    public void setLabelFor(Component c) {
        Component prev = this.labelTarget;
        this.labelTarget = c;
        this.firePropertyChange("labelFor", prev, c);
        if (prev instanceof JComponent) {
            GuiUtils.setLabelFor((JComponent)prev, null);
        }
        if (c instanceof JComponent) {
            GuiUtils.setLabelFor((JComponent)c, this);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultilineLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultilineLabel
    extends JTextArea.AccessibleJTextArea {
        protected AccessibleMultilineLabel() {
            super(MultilineLabel.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MultilineLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return MultilineLabel.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

