/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.DropShadowBorder;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.RoundRectBorder;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ModeSwitchMessagePane
extends JPanel
implements DropShadowBorder.ShadowShape {
    private static final Color BACKGROUND_COLOUR = new Color(0x383636);
    private static final int BORDER_WIDTH = 3;
    private static final int BORDER_ARC = 17;
    private static final Color BORDER_COLOUR = Color.BLACK;
    private static final int KEYLINE_WIDTH = 1;
    private static final int KEYLINE_ARC = 13;
    private static final Color KEYLINE_COLOUR = new Color(10000021);
    private static final float SHADOW_ALPHA = 0.6f;
    private static final double SHADOW_ANGLE = 60.0;
    private static final int SHADOW_DISTANCE = 5;
    private static final Color SHADOW_COLOUR = Color.BLACK;
    private static final float MESSAGE_TEXT_SIZE = 18.0f;
    private static final Color TRANSPARENT_COLOUR = new Color(0, 0, 0, 0);
    private static final int ANIMATION_ICON_SIZE = 47;
    private static final int ANIMATION_CELL_COUNT = 8;
    private static final int ANIMATION_FRAME_COUNT = 16;
    private static final int ANIMATION_INNER_DIAMETER = 10;
    private static final int ANIMATION_OUTER_THICKNESS = 2;
    private static final int ANIMATION_INNER_RGB = 15384913;
    private static final int ANIMATION_OUTER_RGB = 0x636363;
    private static final int ANIMATION_LINE_RGB = 0x535353;
    private static final int ANIMATION_CENTRE_X = 23;
    private static final int ANIMATION_CENTRE_Y = 23;
    private static final double ANIMATION_CELL_RADIUS = 16.0;
    private static final double ANIMATION_ALPHA_DECAY = 1.0 / Math.sqrt(1.666667);
    private I18n i18n = I18n.create((Object)this);
    private JLabel iconLabel;
    private MultilineLabel messageLabel;
    private AnimationIcon messageIcon = new AnimationIcon();
    private LightweightTimer animationTimer = null;
    private static BufferedImage[] frameBuffer = null;

    public ModeSwitchMessagePane(String msgText) {
        this();
        this.setText(msgText);
    }

    public ModeSwitchMessagePane() {
        super(new BorderLayout());
        this.iconLabel = new JLabel(this.messageIcon);
        this.iconLabel.setBackground(BACKGROUND_COLOUR);
        this.messageLabel = new MultilineLabel("", 315);
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(18.0f));
        this.messageLabel.setForeground(Color.WHITE);
        this.messageLabel.setBackground(BACKGROUND_COLOUR);
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        JPanel messagePanel = new JPanel(new GridBagLayout());
        messagePanel.setBackground(BACKGROUND_COLOUR);
        messagePanel.setBorder(BorderFactory.createEmptyBorder(16, 24, 16, 24));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 21;
        messagePanel.add((Component)this.iconLabel, gbc);
        gbc.weightx = 1.0;
        messagePanel.add((Component)this.messageLabel, gbc);
        this.add((Component)messagePanel, "North");
        this.add(Box.createHorizontalStrut(413), "South");
        RoundRectBorder rrb0 = new RoundRectBorder(KEYLINE_COLOUR, 1, 13, true);
        RoundRectBorder rrb1 = new RoundRectBorder(Color.BLACK, 3, 17, true, true);
        rrb1.setFillColor(Color.BLACK);
        CompoundBorder b = BorderFactory.createCompoundBorder(rrb1, rrb0);
        DropShadowBorder shadow = new DropShadowBorder(SHADOW_COLOUR, 0.6f, 60.0, 5);
        this.setBorder(BorderFactory.createCompoundBorder(shadow, b));
        this.setBackground(BACKGROUND_COLOUR);
        this.setOpaque(false);
        AncestorListener al = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ev) {
                ModeSwitchMessagePane.this.startAnimationTimer();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ev) {
                final Container parent = ev.getAncestorParent();
                ModeSwitchMessagePane.this.stopAnimationTimer();
                if (parent != null) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            parent.repaint();
                        }
                    };
                    SwingRunnerSupport.invokeLater((Runnable)r);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ev) {
            }
        };
        this.addAncestorListener(al);
    }

    public void setText(String text) {
        this.messageLabel.setText(text);
        this.messageLabel.revalidate();
    }

    @Override
    public Shape getShadowShape(int x, int y, int w, int h) {
        return new RoundRectangle2D.Double(x, y, w, h, 17.0, 17.0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color origColour = g.getColor();
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        g2.setColor(this.getBackground());
        g2.fillRect(ins.left, ins.top, w, h);
        g2.setColor(origColour);
    }

    public JPanel createContainer() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add(Box.createVerticalStrut(18), gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        panel.add(Box.createHorizontalStrut(8), gbc);
        gbc.weightx = 0.0;
        panel.add((Component)this, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 0.5;
        panel.add(Box.createHorizontalStrut(8), gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        panel.add(Box.createVerticalGlue(), gbc);
        panel.setOpaque(false);
        return panel;
    }

    private void startAnimationTimer() {
        if (this.animationTimer == null) {
            Runnable r = new Runnable(){
                private Insets ins = new Insets(0, 0, 0, 0);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!ModeSwitchMessagePane.this.animationTimer.isScheduled()) {
                        return;
                    }
                    Graphics g = null;
                    try {
                        g = ModeSwitchMessagePane.this.iconLabel.getGraphics();
                        if (g != null) {
                            ModeSwitchMessagePane.this.iconLabel.getInsets(this.ins);
                            g.setClip(this.ins.left, this.ins.top, ModeSwitchMessagePane.this.iconLabel.getWidth() - this.ins.left - this.ins.right, ModeSwitchMessagePane.this.iconLabel.getHeight() - this.ins.top - this.ins.bottom);
                            g.setColor(ModeSwitchMessagePane.this.getBackground());
                            g.fillRect(this.ins.left, this.ins.top, ModeSwitchMessagePane.this.iconLabel.getWidth() - this.ins.left - this.ins.right, ModeSwitchMessagePane.this.iconLabel.getHeight() - this.ins.top - this.ins.bottom);
                            ModeSwitchMessagePane.this.iconLabel.paint(g);
                        }
                    }
                    finally {
                        if (g != null) {
                            g.dispose();
                        }
                    }
                }
            };
            this.animationTimer = new LightweightTimer(2, r);
        }
        this.messageIcon.start();
        this.animationTimer.scheduleEvery(this.messageIcon.getInterval());
    }

    private void stopAnimationTimer() {
        this.animationTimer.cancel();
        this.messageIcon.stop();
        this.repaint();
    }

    static /* synthetic */ BufferedImage[] access$502(BufferedImage[] x0) {
        frameBuffer = x0;
        return x0;
    }

    private static class AnimationIcon
    implements Icon {
        private long startTime = -1L;
        private long interval = 62L;

        private AnimationIcon() {
        }

        public void setTime(long millis) {
            this.interval = millis / 16L;
        }

        public long getInterval() {
            return this.interval;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            this.startTime = -1L;
            if (frameBuffer != null) {
                for (BufferedImage frm : frameBuffer) {
                    if (frm == null) continue;
                    frm.flush();
                }
            }
        }

        @Override
        public int getIconWidth() {
            return 47;
        }

        @Override
        public int getIconHeight() {
            return 47;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.startTime < 0L) {
                this.start();
            }
            int n = (int)((System.currentTimeMillis() - this.startTime) / this.interval);
            BufferedImage frm = this.getFrame(n % 16);
            g.drawImage(frm, x, y, null);
        }

        private BufferedImage getFrame(int frameOrdinal) {
            BufferedImage frm;
            if (frameBuffer == null) {
                ModeSwitchMessagePane.access$502(new BufferedImage[16]);
            }
            if ((frm = frameBuffer[frameOrdinal]) == null) {
                frm = new BufferedImage(47, 47, 2);
                this.renderFrame(frameOrdinal, frm);
                frameBuffer[frameOrdinal] = frm;
            }
            return frm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderFrame(int frameOrdinal, BufferedImage frm) {
            Graphics2D g2 = null;
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            try {
                g2 = frm.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setComposite(AlphaComposite.Src);
                g2.setColor(TRANSPARENT_COLOUR);
                g2.fillRect(0, 0, w, h);
                int pos = frameOrdinal / 2;
                int age = frameOrdinal % 2;
                double theta0 = Math.toRadians(-90.0);
                theta0 += (double)pos * 2.0 * Math.PI / 8.0;
                for (int ix = 0; ix < 7; ++ix) {
                    double theta = theta0 - (double)ix * 2.0 * Math.PI / 8.0;
                    double dX = Math.cos(theta) * 16.0;
                    double dY = Math.sin(theta) * 16.0;
                    int x = (int)Math.round(23.0 + dX);
                    int y = (int)Math.round(23.0 + dY);
                    this.paintCell(g2, x, y, age);
                    age += 2;
                }
            }
            finally {
                if (g2 != null) {
                    g2.dispose();
                }
            }
        }

        private void paintCell(Graphics2D g2, int x, int y, int age) {
            double alpha = Math.pow(ANIMATION_ALPHA_DECAY, age);
            int a = ((int)Math.round(alpha * 255.0) & 0xFF) << 24;
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(a | 0xEAC151, true));
            g2.fillOval(x -= 5, y -= 5, 11, 11);
            g2.setColor(new Color(a | 0x535353, true));
            g2.setStroke(new BasicStroke(1.5f));
            g2.drawOval(x, y, 10, 10);
            int outerX = x - 2;
            int outerY = y - 2;
            int outerDiameter = 14;
            g2.setComposite(AlphaComposite.DstOver);
            g2.setColor(new Color(a | 0x636363, true));
            g2.fillOval(outerX, outerY, outerDiameter + 1, outerDiameter + 1);
        }
    }
}

