/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class MarqueeScroller
extends JPanel
implements Runnable,
ComponentListener {
    private static final int DFT_SCROLL_QUANTUM = 2;
    private static final int DFT_INTERVAL = 100;
    private JComponent contentPane = null;
    private JComponent scrollingPane = new JPanel(new BorderLayout());
    private MScrollPane scroller = null;
    private LightweightTimer scrollTimer = null;
    private boolean scrolling = false;
    private int prevX = 0;
    private int prevY = 0;
    private int scrollInterval = 100;
    private int scrollQuantum = 2;
    private Point scrollPos = new Point();
    private boolean scrollOrientationHorizontal = true;

    public MarqueeScroller() {
        this(null, 100);
    }

    public MarqueeScroller(JComponent content) {
        this(content, 100);
    }

    public MarqueeScroller(JComponent content, int interval) {
        super(new BorderLayout());
        this.scrollInterval = interval;
        this.scroller = new MScrollPane(this.scrollingPane);
        this.scrollTimer = new LightweightTimer(2, (Runnable)this);
        this.setScrollingContent(content);
        super.addComponentListener(this);
        super.add((Component)this.scroller, "Center");
    }

    public void setScrollingContent(JComponent content) {
        if (this.contentPane != null) {
            this.scrollingPane.remove(this.contentPane);
            this.contentPane.removeComponentListener(this);
        }
        this.contentPane = content;
        if (this.contentPane != null) {
            this.scrollingPane.add((Component)this.contentPane, "Center");
            this.contentPane.addComponentListener(this);
        }
        this.scroller.revalidate();
    }

    public void setInterval(int interval) {
        if (this.scrollInterval == interval) {
            return;
        }
        this.scrollInterval = interval;
        if (this.scrolling) {
            this.scrollTimer.cancel();
            this.scrollTimer.scheduleEvery((long)this.scrollInterval);
        }
    }

    @Override
    public Component add(Component comp) {
        throw new RuntimeException("Cannot add components directly to " + this.getClass().getName());
    }

    @Override
    public Component add(Component comp, int index) {
        throw new RuntimeException("Cannot add components directly to " + this.getClass().getName());
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new RuntimeException("Cannot add components directly to " + this.getClass().getName());
    }

    @Override
    public void add(Component comp, Object contraints, int index) {
        throw new RuntimeException("Cannot add components directly to " + this.getClass().getName());
    }

    @Override
    public Component add(String name, Component comp) {
        throw new RuntimeException("Cannot add components directly to " + this.getClass().getName());
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentShown(ComponentEvent ev) {
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    @Override
    public void run() {
        boolean isTextWrittenFromLeftToRight = this.contentPane.getComponentOrientation().isLeftToRight();
        if (!this.scrollOrientationHorizontal) {
            int scrollHeight = this.scroller.getViewport().getHeight();
            int contentHeight = this.contentPane.getHeight();
            if (contentHeight <= scrollHeight) {
                this.stopScrolling();
            } else {
                if (!this.scrolling) {
                    this.startScrolling(isTextWrittenFromLeftToRight, this.scrollOrientationHorizontal);
                }
                if (isTextWrittenFromLeftToRight && this.prevY + scrollHeight > contentHeight + 4 * this.scrollQuantum + 1) {
                    this.prevY = -4 * this.scrollQuantum;
                } else if (!isTextWrittenFromLeftToRight && this.prevX < -4 * this.scrollQuantum) {
                    this.prevY = contentHeight + 1 - scrollHeight + 4 * this.scrollQuantum;
                }
                this.prevY = isTextWrittenFromLeftToRight ? (this.prevY += this.scrollQuantum) : (this.prevY -= this.scrollQuantum);
                int y = this.prevY;
                if (y < 0) {
                    y = 0;
                } else if (y + scrollHeight > contentHeight + 1) {
                    y = contentHeight + 1 - scrollHeight;
                }
                this.scrollPos.setLocation(0, y);
                try {
                    this.scroller.getViewport().setViewPosition(this.scrollPos);
                }
                catch (Throwable t) {}
            }
        } else {
            int scrollWidth = this.scroller.getViewport().getWidth();
            int contentWidth = this.contentPane.getWidth();
            if (contentWidth <= scrollWidth) {
                this.stopScrolling();
            } else {
                if (!this.scrolling) {
                    this.startScrolling(isTextWrittenFromLeftToRight, this.scrollOrientationHorizontal);
                }
                if (isTextWrittenFromLeftToRight && this.prevX + scrollWidth > contentWidth + 4 * this.scrollQuantum + 1) {
                    this.prevX = -4 * this.scrollQuantum;
                } else if (!isTextWrittenFromLeftToRight && this.prevX < -4 * this.scrollQuantum) {
                    this.prevX = contentWidth + 1 - scrollWidth + 4 * this.scrollQuantum;
                }
                this.prevX = isTextWrittenFromLeftToRight ? (this.prevX += this.scrollQuantum) : (this.prevX -= this.scrollQuantum);
                int x = this.prevX;
                if (x < 0) {
                    x = 0;
                } else if (x + scrollWidth > contentWidth + 1) {
                    x = contentWidth + 1 - scrollWidth;
                }
                this.scrollPos.setLocation(x, 0);
                try {
                    this.scroller.getViewport().setViewPosition(this.scrollPos);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    private void startScrolling(boolean leftToRight, boolean scrollOrientationHorizontal) {
        this.scroller.revalidate();
        this.scrolling = true;
        if (scrollOrientationHorizontal) {
            this.prevX = leftToRight ? 0 : this.contentPane.getWidth() - this.scroller.getViewport().getWidth();
        } else {
            this.prevY = leftToRight ? 0 : this.contentPane.getHeight() - this.scroller.getViewport().getHeight();
        }
        this.scrollTimer.scheduleEvery((long)this.scrollInterval);
    }

    private void stopScrolling() {
        if (!this.scrolling) {
            return;
        }
        this.scrollTimer.cancel();
        this.scrollPos.setLocation(0, 0);
        try {
            this.scroller.getViewport().setViewPosition(this.scrollPos);
        }
        catch (Throwable t) {
            return;
        }
        this.scroller.revalidate();
        this.scrolling = false;
        this.prevX = 0;
    }

    @Override
    public void hide() {
        this.stopScrolling();
    }

    public boolean isScrollOrientationHorizontal() {
        return this.scrollOrientationHorizontal;
    }

    public void setScrollOrientationHorizontal(boolean scrollOrientationHorizontal) {
        this.scrollOrientationHorizontal = scrollOrientationHorizontal;
    }

    private static class MScrollPane
    extends JScrollPane {
        MScrollPane(JComponent jc) {
            super(jc, 21, 31);
            super.setBorder(null);
        }

        @Override
        public void setBorder(Border b) {
        }
    }
}

