/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.KeyConfigPanel;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class HotKeyPane
extends JPanel {
    I18n i18n = I18n.create((Object)this);
    BorderLayout layout = new BorderLayout();
    KeyConfigPanel keySequence = new KeyConfigPanel();
    JLabel title = new JLabel();

    HotKeyPane() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"HotKeyPane", (Throwable)ex, (boolean)true);
        }
    }

    public KeyStroke getKeyStroke() {
        int code = this.keySequence.getKeyCode();
        int mods = this.keySequence.getKeyModifiers();
        if (code == 0) {
            return null;
        }
        return KeyStroke.getKeyStroke(code, mods);
    }

    public void setKeyStroke(KeyStroke stroke) {
        if (stroke == null) {
            this.keySequence.setKeyCode(0);
            this.keySequence.setKeyMods(0);
        } else {
            this.keySequence.setKeyCode(stroke.getKeyCode());
            this.keySequence.setKeyMods(stroke.getModifiers());
        }
    }

    private void jbInit() throws Exception {
        this.title.setText(this.i18n.getString((PropertiesEnum)StringsProperties.HOTKEYPANE_PROMPT));
        this.setLayout(this.layout);
        this.keySequence.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.add((Component)this.title, "North");
        this.add((Component)this.keySequence, "Center");
    }

    public static KeyStroke getHotKey(Component parent, String title, KeyStroke stroke) {
        HotKeyPane input = new HotKeyPane();
        Object[] message = new Object[]{input};
        input.setKeyStroke(stroke);
        JOptionPane pane = new JOptionPane(message, 3, 2);
        ModalDialog.showCustomDialog(parent, pane, title, input.keySequence.getPrimaryComponent());
        int option = -1;
        Object selectedValue = pane.getValue();
        if (selectedValue instanceof Integer) {
            option = (Integer)selectedValue;
        }
        if (option == 0) {
            return input.getKeyStroke();
        }
        return stroke;
    }
}

