/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class HistogramPanel
extends JPanel {
    private int[] histogramData;
    private int maxBin;
    private int maxCount;

    public HistogramPanel(int nBins) {
        this.histogramData = new int[nBins];
        this.maxBin = 0;
        this.maxCount = 1;
    }

    public void update(short[] data) {
        this.update(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(short[] data, int start, int len) {
        int binSize = (65535 + this.histogramData.length / 2) / this.histogramData.length;
        if (binSize < 1) {
            binSize = 1;
        }
        int[] nArray = this.histogramData;
        synchronized (this.histogramData) {
            int ix;
            for (ix = 0; ix < this.histogramData.length; ++ix) {
                this.histogramData[ix] = 0;
            }
            for (ix = start; ix < len; ++ix) {
                int bin = (data[ix] - Short.MIN_VALUE) / binSize;
                if (bin >= this.histogramData.length) {
                    bin = this.histogramData.length - 1;
                }
                int n = bin;
                this.histogramData[n] = this.histogramData[n] + 1;
            }
            this.maxBin = 0;
            this.maxCount = 0;
            for (ix = 0; ix < this.histogramData.length; ++ix) {
                if (this.histogramData[ix] <= this.maxCount) continue;
                this.maxBin = ix;
                this.maxCount = this.histogramData[ix];
            }
            if (this.maxCount < 1) {
                this.maxCount = 1;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.repaint();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Rectangle r = this.getBounds();
        Insets ins = this.getInsets();
        r.x = ins.left;
        r.y = ins.top;
        r.width -= ins.left + ins.right;
        r.height -= ins.top + ins.bottom;
        if (r.width < 0) {
            return;
        }
        if (r.height < 0) {
            return;
        }
        int[] nArray = this.histogramData;
        synchronized (this.histogramData) {
            g.setColor(Color.white);
            g.fillRect(r.x, r.y, r.width, r.height);
            int y = r.y;
            for (int ix = 0; ix < this.histogramData.length; ++ix) {
                int y1 = r.y + ((ix + 1) * r.height + this.histogramData.length / 2) / this.histogramData.length;
                int h = y1 - y;
                int w = (r.width * this.histogramData[ix] + this.maxCount / 2) / this.maxCount;
                if (w > r.width) {
                    w = r.width;
                }
                g.setColor(Color.blue);
                g.fillRect(r.x, y, w, h);
                g.setColor(Color.black);
                g.drawRect(r.x, y, w, h);
                y = y1;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

