/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class CDisclosureButton
extends JToggleButton {
    private static final I18n i18n = I18n.create(CDisclosureButton.class);

    public CDisclosureButton() {
        this(false);
    }

    public CDisclosureButton(boolean expanded) {
        this((String)null, expanded);
    }

    public CDisclosureButton(String text) {
        this(text, false);
    }

    public CDisclosureButton(String text, boolean expanded) {
        super(text, expanded);
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.setContentAreaFilled(false);
        this.setHorizontalAlignment(10);
        this.applyIcon();
    }

    private void applyIcon() {
        if (this.isSelected()) {
            switch (Platform.getOS()) {
                case 406: {
                    this.setIcon(i18n.getIcon("DisclosureButton.collapseIconVista"));
                    break;
                }
                case 405: {
                    this.setIcon(i18n.getIcon("DisclosureButton.collapseIconXP"));
                    break;
                }
                case 202: {
                    this.setIcon(UIManager.getIcon("Tree.expandedIcon"));
                    break;
                }
                default: {
                    this.setIcon(i18n.getIcon("DisclosureButton.collapseIconGeneric"));
                    break;
                }
            }
        } else {
            switch (Platform.getOS()) {
                case 406: {
                    this.setIcon(i18n.getIcon("DisclosureButton.expandIconVista"));
                    break;
                }
                case 405: {
                    this.setIcon(i18n.getIcon("DisclosureButton.expandIconXP"));
                    break;
                }
                case 202: {
                    this.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
                    break;
                }
                default: {
                    this.setIcon(i18n.getIcon("DisclosureButton.expandIconGeneric"));
                }
            }
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent e) {
        this.applyIcon();
        super.fireItemStateChanged(e);
    }
}

