/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class BadgedIcon
implements Icon {
    public static final int BADGE_IN_LOWER_LEFT = 0;
    public static final int BADGE_IN_LOWER_RIGHT = 1;
    public static final int BADGE_IN_UPPER_LEFT = 2;
    public static final int BADGE_IN_UPPER_RIGHT = 3;
    private static final int BADGE_MANUALLY = 4;
    private Icon base = null;
    private Icon badge = null;
    private int positioning = 1;
    private int offsetX = 0;
    private int offsetY = 0;

    public BadgedIcon(Icon icon) {
        this(icon, null, 1);
    }

    public BadgedIcon(Icon base, Icon badge) {
        this(base, badge, 1);
    }

    public BadgedIcon(Icon base, Icon badge, int positioning) {
        this.base = base;
        this.badge = badge;
        this.positioning = positioning;
    }

    public BadgedIcon(Icon base, Icon badge, int x, int y) {
        this.base = base;
        this.badge = badge;
        this.positioning = 4;
        this.offsetX = x;
        this.offsetY = y;
    }

    public Icon getBase() {
        return this.base;
    }

    public void setBase(Icon base) {
        this.base = base;
    }

    public boolean isBadged() {
        return this.badge != null;
    }

    public Icon getBadge() {
        return this.badge;
    }

    public void setBadge(Icon badge) {
        this.badge = badge;
    }

    public void setBadge(Icon badge, int positioning) {
        this.badge = badge;
        this.positioning = positioning;
    }

    public void setBadge(Icon badge, int x, int y) {
        this.badge = badge;
        this.positioning = 4;
        this.offsetX = x;
        this.offsetY = y;
    }

    @Override
    public int getIconHeight() {
        int h;
        int n = h = this.base == null ? 0 : this.base.getIconHeight();
        if (this.badge != null) {
            switch (this.positioning) {
                default: {
                    h += this.badge.getIconHeight() / 3;
                    break;
                }
                case 4: {
                    int h2;
                    if (this.offsetY < 0) {
                        h -= this.offsetY;
                    }
                    if ((h2 = this.offsetY + this.badge.getIconHeight()) <= h) break;
                    h = h2;
                }
            }
        }
        return h;
    }

    @Override
    public int getIconWidth() {
        int w;
        int n = w = this.base == null ? 0 : this.base.getIconWidth();
        if (this.badge != null) {
            switch (this.positioning) {
                default: {
                    w += this.badge.getIconWidth() / 3;
                    break;
                }
                case 4: {
                    int w2;
                    if (this.offsetX < 0) {
                        w -= this.offsetX;
                    }
                    if ((w2 = this.offsetX + this.badge.getIconWidth()) <= w) break;
                    w = w2;
                }
            }
        }
        return w;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int dy;
        int dx;
        int h1;
        int w1;
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        if (this.base != null) {
            w1 = this.base.getIconWidth();
            h1 = this.base.getIconWidth();
            switch (this.positioning) {
                default: {
                    dx = w - w1;
                    dy = 0;
                    break;
                }
                case 1: {
                    dx = 0;
                    dy = 0;
                    break;
                }
                case 2: {
                    dx = w - w1;
                    dy = h - h1;
                    break;
                }
                case 3: {
                    dx = 0;
                    dy = h - h1;
                    break;
                }
                case 4: {
                    dx = 0;
                    dy = 0;
                    if (this.offsetX < 0) {
                        dx = -this.offsetX;
                    }
                    if (this.offsetY >= 0) break;
                    dy = -this.offsetY;
                }
            }
            this.base.paintIcon(c, g, x + dx, y + dy);
        }
        if (this.badge != null) {
            w1 = this.badge.getIconWidth();
            h1 = this.badge.getIconWidth();
            switch (this.positioning) {
                default: {
                    dx = 0;
                    dy = h - h1;
                    break;
                }
                case 1: {
                    dx = w - w1;
                    dy = h - h1;
                    break;
                }
                case 2: {
                    dx = 0;
                    dy = 0;
                    break;
                }
                case 3: {
                    dx = w - w1;
                    dy = 0;
                    break;
                }
                case 4: {
                    dx = 0;
                    dy = 0;
                    if (this.offsetX < 0) {
                        dx = -this.offsetX;
                    }
                    if (this.offsetY >= 0) break;
                    dy = -this.offsetY;
                }
            }
            this.badge.paintIcon(c, g, x + dx, y + dy);
        }
    }

    public String toString() {
        String posInfo;
        switch (this.positioning) {
            default: {
                posInfo = "LL";
                break;
            }
            case 1: {
                posInfo = "LR";
                break;
            }
            case 2: {
                posInfo = "UL";
                break;
            }
            case 3: {
                posInfo = "UR";
                break;
            }
            case 4: {
                posInfo = "@" + this.offsetX + "," + this.offsetY;
            }
        }
        return "BadgedIcon: base=" + this.base + " badge=" + this.badge + " position=" + posInfo;
    }
}

