/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class AlphaIcon
implements Icon {
    private Icon icon = null;
    private float alpha = 1.0f;

    public AlphaIcon(Icon icon) {
        this(icon, 1.0f);
    }

    public AlphaIcon(Icon icon, int alpha) {
        this(icon, (float)alpha / 255.0f);
    }

    public AlphaIcon(Icon icon, float alpha) {
        this.icon = icon;
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.setAlpha((float)alpha / 255.0f);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha < 0.0f ? 0.0f : (alpha > 1.0f ? 1.0f : alpha);
    }

    @Override
    public int getIconHeight() {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            AlphaComposite composite = AlphaComposite.getInstance(3, this.alpha);
            g2.setComposite(composite);
            this.icon.paintIcon(c, g2, x, y);
            g2.dispose();
        } else {
            this.icon.paintIcon(c, g, x, y);
        }
    }

    public String toString() {
        return "AlphaIcon: alpha=" + this.alpha + " icon=" + this.icon;
    }
}

