/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class AccessibleToolBar
extends JToolBar {
    KeyStroke toggleFocusKeystroke = KeyStroke.getKeyStroke(119, 512);
    static final String TOGGLE_FOCUS_ACTION_KEY = "toggle.focus.action";

    public AccessibleToolBar() {
        this(null, 0);
    }

    public AccessibleToolBar(int orientation) {
        this(null, orientation);
    }

    public AccessibleToolBar(String name) {
        this(name, 0);
    }

    public AccessibleToolBar(String name, int orientation) throws IllegalArgumentException {
        super(name, orientation);
        this.enableDefaultKeyBinding();
    }

    public void toggleButtonFocus() {
        Component[] componentList;
        for (Component component : componentList = this.getComponents()) {
            AbstractButton btn;
            if (!(component instanceof AbstractButton)) continue;
            btn.setFocusable(!(btn = (AbstractButton)component).isFocusable());
        }
    }

    public void disableDefaultKeyBinding() {
        ActionMap amap;
        InputMap imap = this.getInputMap(2);
        if (imap.get(this.toggleFocusKeystroke) != null) {
            imap.remove(this.toggleFocusKeystroke);
        }
        if ((amap = this.getActionMap()).get(TOGGLE_FOCUS_ACTION_KEY) != null) {
            amap.remove(TOGGLE_FOCUS_ACTION_KEY);
        }
    }

    public void enableDefaultKeyBinding() {
        InputMap imap = this.getInputMap(2);
        imap.put(this.toggleFocusKeystroke, TOGGLE_FOCUS_ACTION_KEY);
        ActionMap amap = this.getActionMap();
        amap.put(TOGGLE_FOCUS_ACTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessibleToolBar.this.toggleButtonFocus();
            }
        });
    }
}

