/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.StringsProperties;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.event.ModalDialogAsyncEvent;
import com.elluminate.gui.event.ModalDialogAsyncListener;
import com.elluminate.gui.event.ModalDialogAsyncRequest;
import com.elluminate.gui.swing.CPasswordField;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class ModalDialog {
    public static final int NEVER_TIMEOUT = -1;
    public static final Object UNINITIALIZED_VALUE = JOptionPane.UNINITIALIZED_VALUE;
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static I18n i18n = I18n.create(ModalDialog.class);
    private static final RequestList queue = new RequestList();
    private static final ProcessorThread processor = new ProcessorThread();
    private static final int DFT_TIMEOUT = -1;
    private static Window remapFrom = null;
    private static Window remapTo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setParentRemapping(Window from, Window to) {
        Class<ModalDialog> clazz = ModalDialog.class;
        synchronized (ModalDialog.class) {
            remapFrom = from;
            remapTo = to;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (from != null && to != null) {
                ProcessorThread.reparentShowingDialog(from, to);
            }
            return;
        }
    }

    public static void showMessageDialog(Component parent, Object message) {
        ModalDialog.showDialogTimeout(-1, parent, message, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_DFTMESSAGETITLE), 1, false, -1, null, null, null, null);
    }

    public static void showMessageDialogTimeout(int seconds, Component parent, Object message) {
        ModalDialog.showDialogTimeout(seconds, parent, message, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_DFTMESSAGETITLE), 1, false, -1, null, null, null, null);
    }

    public static ModalDialogAsyncRequest showMessageDialogAsync(int seconds, Component parent, Object message) {
        return ModalDialog.showDialogAsync(seconds, parent, message, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_DFTMESSAGETITLE), 1, false, -1, null, null, null, null);
    }

    public static void showMessageDialog(Component parent, Object message, String title, int msgType) {
        ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, false, -1, null, null, null, null);
    }

    public static void showMessageDialogTimeout(int seconds, Component parent, Object message, String title, int msgType) {
        ModalDialog.showDialogTimeout(seconds, parent, message, title, msgType, false, -1, null, null, null, null);
    }

    public static ModalDialogAsyncRequest showMessageDialogAsync(int seconds, Component parent, Object message, String title, int msgType) {
        return ModalDialog.showDialogAsync(seconds, parent, message, title, msgType, false, -1, null, null, null, null);
    }

    public static void showMessageDialog(Component parent, Object message, String title, int msgType, Icon icon) {
        ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, false, -1, icon, null, null, null);
    }

    public static void showMessageDialogTimeout(int seconds, Component parent, Object message, String title, int msgType, Icon icon) {
        ModalDialog.showDialogTimeout(seconds, parent, message, title, msgType, false, -1, icon, null, null, null);
    }

    public static int showConfirmDialog(Component parent, Object message) {
        return ModalDialog.showDialogTimeout(-1, parent, message, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_DFTCONFIRMTITLE), 3, true, 1, null, null, null, null);
    }

    public static int showConfirmDialog(Component parent, Object message, String title, int optType) {
        return ModalDialog.showDialogTimeout(-1, parent, message, title, 3, true, optType, null, null, null, null);
    }

    public static int showConfirmDialog(Component parent, Object message, String title, int optType, int msgType) {
        return ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, true, optType, null, null, null, null);
    }

    public static int showConfirmDialog(Component parent, Object message, String title, int optType, int msgType, Icon icon) {
        return ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, true, optType, icon, null, null, null);
    }

    public static int showConfirmDialogTimeout(int seconds, Component parent, Object message, String title, int optType, int msgType, Icon icon) {
        return ModalDialog.showDialogTimeout(seconds, parent, message, title, msgType, true, optType, icon, null, null, null);
    }

    public static int showConfirmDialogTimeout(int seconds, Component parent, Object message, String title, int optType, int msgType, Icon icon, boolean alwaysOnTop) {
        return ModalDialog.showDialogTimeout(seconds, parent, message, title, msgType, true, optType, icon, null, null, null, alwaysOnTop);
    }

    public static String showInputDialog(Object message) {
        Object result = null;
        result = ModalDialog.showInputDialogTimeout(-1, null, message, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_DFTINPUTTITLE), 3, true, 2, null, null, null, null);
        if (result == null) {
            return null;
        }
        if (result == UNINITIALIZED_VALUE) {
            return null;
        }
        return result.toString();
    }

    public static String showInputDialog(Component parent, Object message) {
        return ModalDialog.showInputDialog(parent, message, null);
    }

    public static String showInputDialog(Component parent, Object message, String initValue) {
        Object result = null;
        result = ModalDialog.showInputDialogTimeout(-1, parent, message, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_DFTINPUTTITLE), 3, true, 2, null, null, initValue, null);
        if (result == null) {
            return null;
        }
        if (result == UNINITIALIZED_VALUE) {
            return null;
        }
        return result.toString();
    }

    public static String showInputDialog(Component parent, Object message, String title, int msgType) {
        return ModalDialog.showInputDialog(parent, message, title, msgType, null);
    }

    public static String showInputDialog(Component parent, Object message, String title, int msgType, String initValue) {
        Object result = null;
        result = ModalDialog.showInputDialogTimeout(-1, parent, message, title, msgType, true, 2, null, null, initValue, null);
        if (result == null) {
            return null;
        }
        if (result == UNINITIALIZED_VALUE) {
            return null;
        }
        return result.toString();
    }

    public static int showOptionDialog(Component parent, Object message, String title, int optType, int msgType, Icon icon, Object[] options, Object initialValue, boolean alwaysOnTop) {
        return ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, true, optType, icon, options, initialValue, null, alwaysOnTop);
    }

    public static int showOptionDialog(Component parent, Object message, String title, int optType, int msgType, Icon icon, Object[] options, Object initialValue) {
        return ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, true, optType, icon, options, initialValue, null);
    }

    public static int showOptionDialog(Component parent, Object message, String title, int optType, int msgType, Icon icon, Object[] options, Object initialValue, Object focus) {
        return ModalDialog.showDialogTimeout(-1, parent, message, title, msgType, true, optType, icon, options, initialValue, focus);
    }

    public static char[] showPasswordDialog(Component parent, String prompt, String title) {
        return ModalDialog.showPasswordDialog(parent, prompt, title, null);
    }

    public static char[] showPasswordDialog(Component parent, String prompt, String title, Object[] extras) {
        int which;
        CPasswordField pw = new CPasswordField(20);
        pw.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        int count = 2 + (extras != null ? extras.length : 0);
        Object[] message = new Object[count];
        message[0] = prompt;
        message[1] = pw;
        if (extras != null) {
            for (int ix = 0; ix < extras.length; ++ix) {
                message[2 + ix] = extras[ix];
            }
        }
        if ((which = ModalDialog.showDialogTimeout(-1, parent, message, title, 3, true, 2, null, null, pw, pw)) != 0) {
            return null;
        }
        return pw.getPassword();
    }

    public static char[] showNewPasswordDialog(Component parent, String prompt1, String prompt2, String title) {
        return ModalDialog.showNewPasswordDialog(parent, prompt1, prompt2, title, null, true);
    }

    public static char[] showNewPasswordDialog(Component parent, String prompt1, String prompt2, String title, Object[] extras) {
        return ModalDialog.showNewPasswordDialog(parent, prompt1, prompt2, title, extras, true);
    }

    public static char[] showNewPasswordDialog(Component parent, String prompt1, String prompt2, final String title, Object[] extras, boolean allowBlank) {
        final CPasswordField pw1 = new CPasswordField(20);
        pw1.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        final CPasswordField pw2 = new CPasswordField(20);
        pw2.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        content.add((Component)new JLabel(prompt1), gbc);
        gbc.insets.top = 3;
        content.add((Component)pw1, gbc);
        gbc.insets.top = 6;
        content.add((Component)new JLabel(prompt2), gbc);
        gbc.insets.top = 3;
        content.add((Component)pw2, gbc);
        gbc.insets.top = 6;
        if (extras != null) {
            for (int ix = 0; ix < extras.length; ++ix) {
                if (extras[ix] == null) continue;
                Component c = null;
                c = extras[ix] instanceof Component ? (Component)extras[ix] : (extras[ix] instanceof Icon ? new JLabel((Icon)extras[ix]) : new JLabel(extras[ix].toString()));
                content.add(c, gbc);
            }
        }
        final Component parentComponent = ModalDialog.findShowingAncestor(parent);
        DialogRequest req = ModalDialog.makeRequest(-1, parentComponent, content, title, 3, true, 2, null, null, null, false, pw1, false);
        req.setVerifier(new Verifier(){

            @Override
            public boolean verify(Object selection, Object context) {
                int ix;
                if (selection == null) {
                    return true;
                }
                int which = ((Number)selection).intValue();
                if (which != 0) {
                    return true;
                }
                char[] pass1 = pw1.getPassword();
                char[] pass2 = pw2.getPassword();
                boolean match = true;
                boolean blank = true;
                for (ix = 0; ix < pass1.length; ++ix) {
                    if (pass1[ix] == ' ') continue;
                    blank = false;
                    break;
                }
                if (pass1.length != pass2.length) {
                    match = false;
                } else {
                    for (int i = 0; i < pass1.length; ++i) {
                        if (pass1[i] == pass2[i]) continue;
                        match = false;
                        break;
                    }
                }
                for (ix = 0; ix < pass1.length; ++ix) {
                    pass1[ix] = '\u0000';
                }
                for (ix = 0; ix < pass2.length; ++ix) {
                    pass2[ix] = '\u0000';
                }
                if (!match) {
                    JOptionPane.showMessageDialog(parentComponent, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_PASSWORDMISMATCH), title, 0);
                    return false;
                }
                if (blank) {
                    JOptionPane.showMessageDialog(parentComponent, i18n.getString((PropertiesEnum)StringsProperties.MODALDIALOG_PASSWORDBLANK), title, 0);
                    return false;
                }
                return true;
            }
        }, null);
        int which = req.queueRequestIntResult();
        if (which != 0) {
            return null;
        }
        return pw1.getPassword();
    }

    public static void showCustomDialog(Component parent, JOptionPane optPane, String title) {
        ModalDialog.showCustomDialogTimeout(-1, parent, optPane, title, null);
    }

    public static void showCustomDialog(Component parent, JOptionPane optPane, String title, Object focus) {
        ModalDialog.showCustomDialogTimeout(-1, parent, optPane, title, focus);
    }

    public static void showCustomDialog(Component parent, JOptionPane optPane, String title, Object focus, boolean findShowingAncestor) {
        ModalDialog.showCustomDialogTimeout(-1, parent, optPane, title, focus, findShowingAncestor);
    }

    public static void showCustomDialogTimeout(int timeout, Component parent, JOptionPane optPane, String title) {
        ModalDialog.showCustomDialogTimeout(timeout, parent, optPane, title, null);
    }

    public static void showCustomDialogTimeout(int timeout, Component parent, JOptionPane optPane, String title, Object focus) {
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, title, optPane, focus, false, true);
        req.queueRequest();
    }

    public static void showCustomDialogTimeout(int timeout, Component parent, JOptionPane optPane, String title, Object focus, boolean findShowingAncestor) {
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, title, optPane, focus, false, findShowingAncestor);
        req.queueRequest();
    }

    private static int showDialogTimeout(int timeout, Component parent, Object message, String title, int msgType, boolean useOptType, int optType, Icon icon, Object[] options, Object initValue, Object focus) {
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, message, title, msgType, useOptType, optType, icon, options, initValue, false, focus, false);
        return req.queueRequestIntResult();
    }

    private static int showDialogTimeout(int timeout, Component parent, Object message, String title, int msgType, boolean useOptType, int optType, Icon icon, Object[] options, Object initValue, Object focus, boolean alwaysOnTop) {
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, message, title, msgType, useOptType, optType, icon, options, initValue, false, focus, alwaysOnTop);
        return req.queueRequestIntResult();
    }

    private static ModalDialogAsyncRequest showDialogAsync(int timeout, Component parent, Object message, String title, int msgType, boolean useOptType, int optType, Icon icon, Object[] options, Object initValue, Object focus) {
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, message, title, msgType, useOptType, optType, icon, options, initValue, false, focus, false);
        req.queueRequest(false);
        return req;
    }

    private static Object showInputDialogTimeout(int timeout, Component parent, Object message, String title, int msgType, boolean useOptType, int optType, Icon icon, Object[] options, Object initValue, Object focus) {
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, message, title, msgType, useOptType, optType, icon, options, initValue, true, focus, false);
        return req.queueRequest();
    }

    private static DialogRequest makeRequest(int timeout, Component parent, Object message, String title, int msgType, boolean useOptType, int optType, Icon icon, Object[] options, Object initValue, boolean input, Object focus, boolean alwaysOnTop) {
        Object msg = message;
        if (msg instanceof String) {
            msg = ModalDialog.formatMessage((String)msg);
        }
        JOptionPane opt = new JOptionPane(msg, msgType);
        opt.setWantsInput(input);
        if (useOptType) {
            opt.setOptionType(optType);
        }
        if (icon != null) {
            opt.setIcon(icon);
        }
        if (input) {
            if (options != null) {
                opt.setSelectionValues(options);
            }
            if (initValue != null) {
                opt.setInitialSelectionValue(initValue);
            }
        } else {
            if (options != null) {
                opt.setOptions(options);
            }
            if (initValue != null) {
                opt.setInitialValue(initValue);
            }
        }
        DialogRequest req = ModalDialog.makeRequest(timeout, parent, title, opt, focus, alwaysOnTop, true);
        if (options != null) {
            req.setOptions(options);
        }
        return req;
    }

    private static DialogRequest makeRequest(int timeout, Component parent, String title, JOptionPane opt, Object focus, boolean alwaysOnTop, boolean findShowingAncestor) {
        if (!(focus instanceof Component) && !(focus instanceof Class) && focus != null) {
            throw new IllegalArgumentException("Invalid initial focus: " + focus);
        }
        DialogRequest req = new DialogRequest(timeout, parent, title, opt, focus, alwaysOnTop, findShowingAncestor);
        return req;
    }

    private static Component formatMessage(String message) {
        MultilineLabel ml = new MultilineLabel(message);
        if (Platform.getOS() == 202 || message.length() >= 60) {
            ml.setSize(375, Integer.MAX_VALUE);
            ml.setPreferredSize(new Dimension(375, ml.getPreferredSize().height));
        }
        return ml;
    }

    public static void queueAction(final Runnable action, boolean waitFlag) {
        if (waitFlag && SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Called with wait from Swing thread.");
        }
        QueuedRequest req = new QueuedRequest(){

            @Override
            public void execute() {
                action.run();
            }
        };
        req.queueRequest(waitFlag);
    }

    public static void positionWindow(Window w, Component owner) {
        if (w == null) {
            return;
        }
        Rectangle centreOn = new Rectangle();
        Rectangle bounds = w.getBounds();
        Rectangle display = null;
        boolean found = false;
        Component c = ModalDialog.findShowingAncestor(owner);
        Window cw = ModalDialog.findWindow(c);
        if (cw == null) {
            GraphicsConfiguration gconf = GuiUtils.getDevice(0, 0, owner);
            centreOn = display = gconf.getBounds();
        } else {
            centreOn.setBounds(c.getBounds());
            if (c != cw) {
                centreOn = SwingUtilities.convertRectangle(c, centreOn, cw);
                centreOn.translate(cw.getX(), cw.getY());
            }
            display = GuiUtils.getDeviceBounds(centreOn.x, centreOn.y, c);
        }
        int x = centreOn.x + (centreOn.width - bounds.width) / 2;
        int y = centreOn.y + (centreOn.height - bounds.height) / 2;
        if (x + bounds.width > display.x + display.width) {
            x = display.x + display.width - bounds.width;
        }
        if (x < display.x) {
            x = display.x;
        }
        if (y + bounds.height > display.y + display.height) {
            y = display.y + display.height - bounds.height;
        }
        if (y < display.y) {
            y = display.y;
        }
        bounds.setLocation(x, y);
        if (bounds.x + bounds.width > display.x + display.width) {
            bounds.width = display.x + display.width - bounds.x;
        }
        if (bounds.y + bounds.height > display.y + display.height) {
            bounds.height = display.y + display.height - bounds.y;
        }
        w.setBounds(bounds);
    }

    public static Component findShowingAncestor(Component cmp) {
        return ModalDialog.findShowingAncestor(cmp, GuiUtils.getDesktopBounds());
    }

    private static Component findShowingAncestor(Component cmp, Rectangle desktopBounds) {
        for (Component c = cmp; c != null; c = c.getParent()) {
            if (!ModalDialog.checkShowing(c, desktopBounds)) continue;
            return c;
        }
        return null;
    }

    private static boolean checkShowing(Component c, Rectangle desktopBounds) {
        if (c == null) {
            return false;
        }
        if (!c.isShowing()) {
            return false;
        }
        Window w = ModalDialog.findWindow(c);
        if (w == null) {
            return false;
        }
        if (!w.isShowing()) {
            return false;
        }
        if (w instanceof Frame && ((Frame)w).getExtendedState() == 1) {
            return false;
        }
        Point pos = null;
        try {
            pos = c.getLocationOnScreen();
        }
        catch (Throwable t) {
            pos = null;
        }
        if (pos == null) {
            return false;
        }
        Rectangle bounds = c.getBounds();
        bounds.setLocation(pos);
        return bounds.intersects(desktopBounds);
    }

    private static Window findWindow(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return SwingUtilities.windowForComponent(c);
    }

    private static class DialogRequest
    extends QueuedRequest
    implements ModalDialogAsyncRequest {
        private int timeout = -1;
        private Component parent = null;
        private String title = null;
        private JOptionPane optionPane = null;
        private boolean alwaysOnTop = false;
        private boolean findShowingAncestor = false;
        private volatile boolean waiting = true;
        private Component initFocus = null;
        private Class initFocusClass = null;
        private int focusWeight = Integer.MAX_VALUE;
        private volatile JDialog dlg = null;
        private boolean reparented = false;
        private WindowListener wListener = null;
        private final Object listenerLock = new Object();
        private ArrayList<ModalDialogAsyncListener> listenerList = null;

        public DialogRequest(int timeout, Component parent, String title, JOptionPane opt, Object focus, boolean alwaysOnTop, boolean findShowingAncestor) {
            this.timeout = timeout;
            this.parent = parent;
            this.title = title;
            this.optionPane = opt;
            this.alwaysOnTop = alwaysOnTop;
            this.findShowingAncestor = findShowingAncestor;
            this.initFocus = focus instanceof Component ? (Component)focus : null;
            this.initFocusClass = focus instanceof Class ? (Class)focus : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void execute() {
            this.waiting = false;
            if (this.isDone()) {
                return;
            }
            if (UtilDebug.MODAL_DIALOG.show()) {
                LogSupport.message((Object)this, (String)"execute", (String)("Executing request: " + this));
            }
            this.wListener = this.createWindowListener();
            Class<ModalDialog> clazz = ModalDialog.class;
            // MONITORENTER : com.elluminate.gui.ModalDialog.class
            Component parentComponent = null;
            if (this.findShowingAncestor) {
                parentComponent = ModalDialog.findShowingAncestor(this.parent);
            } else {
                parentComponent = this.parent;
                if (!ModalDialog.checkShowing(parentComponent, GuiUtils.getDesktopBounds())) {
                    // MONITOREXIT : clazz
                    return;
                }
            }
            Window w = ModalDialog.findWindow(parentComponent);
            if (remapFrom != null && w == remapFrom) {
                parentComponent = remapTo;
            }
            this.dlg = this.optionPane.createDialog(parentComponent, this.title);
            if (this.alwaysOnTop) {
                this.dlg.setAlwaysOnTop(true);
            }
            this.dlg.pack();
            this.dlg.addWindowListener(this.wListener);
            ModalDialog.positionWindow(this.dlg, parentComponent);
            this.reparented = false;
            if (UtilDebug.MODAL_DIALOG.show()) {
                LogSupport.message((Object)this, (String)"execute", (String)("Created dialog: " + this.dlg));
            }
            // MONITOREXIT : clazz
            this.fireListeners(ModalDialogAsyncEvent.EventType.SHOWN);
            boolean invalid = false;
            while (true) {
                block17: {
                    block15: {
                        block16: {
                            block14: {
                                this.dlg.show();
                                Class<ModalDialog> clazz2 = ModalDialog.class;
                                // MONITORENTER : com.elluminate.gui.ModalDialog.class
                                if (this.reparented) break block14;
                                // MONITOREXIT : clazz2
                                if (!this.optionPane.getWantsInput()) break block15;
                                break block16;
                            }
                            this.reparented = false;
                            // MONITOREXIT : clazz2
                            if (!UtilDebug.MODAL_DIALOG.show()) continue;
                            LogSupport.message((Object)this, (String)"execute", (String)("Detected reparenting, reshowing: " + this));
                            continue;
                        }
                        this.result = this.optionPane.getInputValue();
                        break block17;
                    }
                    this.result = this.optionPane.getValue();
                }
                if (this.verifier != null) {
                    boolean bl = invalid = !this.verifier.verify(this.result, this.verifierContext);
                }
                if (!invalid) break;
            }
            this.dlg.dispose();
            this.dlg = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void reparentDialog(Window win, Component newParent) {
            Class<ModalDialog> clazz = ModalDialog.class;
            synchronized (ModalDialog.class) {
                final JDialog oldDialog = this.dlg;
                if (oldDialog != null) {
                    Component parentComponent = ModalDialog.findShowingAncestor(newParent);
                    Window w = ModalDialog.findWindow(parentComponent);
                    if (remapFrom != null && w == remapFrom) {
                        parentComponent = remapTo;
                    }
                    JDialog newDialog = this.optionPane.createDialog(parentComponent, this.title);
                    oldDialog.removeWindowListener(this.wListener);
                    newDialog.addWindowListener(this.wListener);
                    newDialog.setBounds(oldDialog.getBounds());
                    this.dlg = newDialog;
                    this.reparented = true;
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            oldDialog.dispose();
                        }
                    });
                    if (UtilDebug.MODAL_DIALOG.show()) {
                        LogSupport.message((Object)this, (String)"reparentDialog", (String)("Reparented: " + this));
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        void markDone() {
            boolean mustFire = !this.isDone();
            super.markDone();
            if (mustFire) {
                this.fireListeners(ModalDialogAsyncEvent.EventType.DISMISSED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Debug.lockEnter((Object)this, (String)"cancel", (String)"Cancel Request", (Object)this);
            try {
                JDialog d = this.dlg;
                if (d != null) {
                    d.setVisible(false);
                }
                DialogRequest dialogRequest = this;
                synchronized (dialogRequest) {
                    queue.remove(this);
                    this.markDone();
                    this.notify();
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"cancel", (String)"Cancel Request", (Object)this);
            }
        }

        @Override
        public boolean isCompleted() {
            return this.isDone();
        }

        @Override
        public boolean isShowing() {
            return this.dlg != null && this.dlg.isVisible();
        }

        @Override
        public boolean isWaiting() {
            return this.waiting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ModalDialogAsyncListener l) {
            Object object = this.listenerLock;
            synchronized (object) {
                int n = 0;
                if (this.listenerList != null) {
                    if (this.listenerList.contains(l)) {
                        return;
                    }
                    n = this.listenerList.size();
                }
                ArrayList<ModalDialogAsyncListener> copy = new ArrayList<ModalDialogAsyncListener>(n + 1);
                if (this.listenerList != null) {
                    copy.addAll(this.listenerList);
                }
                copy.add(l);
                this.listenerList = copy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(ModalDialogAsyncListener l) {
            Object object = this.listenerLock;
            synchronized (object) {
                if (this.listenerList == null) {
                    return;
                }
                if (!this.listenerList.contains(l)) {
                    return;
                }
                ArrayList<ModalDialogAsyncListener> copy = null;
                if (this.listenerList.size() > 1) {
                    copy = new ArrayList<ModalDialogAsyncListener>(this.listenerList);
                    copy.remove(l);
                }
                this.listenerList = copy;
            }
        }

        private void fireListeners(ModalDialogAsyncEvent.EventType type) {
            ArrayList<ModalDialogAsyncListener> list = this.listenerList;
            if (list == null) {
                return;
            }
            ModalDialogAsyncEvent ev = null;
            for (ModalDialogAsyncListener l : list) {
                if (l == null) continue;
                if (ev == null) {
                    ev = new ModalDialogAsyncEvent(this, type);
                }
                try {
                    switch (type) {
                        case SHOWN: {
                            l.dialogShown(ev);
                            break;
                        }
                        case DISMISSED: {
                            l.dialogDismissed(ev);
                        }
                    }
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"fireListeners", (Throwable)t, (boolean)true);
                }
            }
        }

        private WindowListener createWindowListener() {
            return new MDWindowListener();
        }

        private void findInitFocusComponentByClass(Component cmp) {
            if (this.initFocusClass.isInstance(cmp)) {
                this.initFocus = cmp;
                this.focusWeight = Integer.MAX_VALUE;
                return;
            }
            if (cmp instanceof Container) {
                Component[] list = ((Container)cmp).getComponents();
                for (int ix = 0; ix < list.length; ++ix) {
                    this.findInitFocusComponentByClass(list[ix]);
                    if (this.initFocus == null || this.focusWeight != Integer.MAX_VALUE) continue;
                    return;
                }
            }
        }

        private class MDWindowListener
        extends WindowAdapter {
            private volatile LightweightTimer watchdog = null;
            private volatile boolean gotFocus = false;
            private LightweightTimer focusizer = new LightweightTimer(2, (Runnable)new FocusAction());

            private MDWindowListener() {
            }

            @Override
            public void windowActivated(WindowEvent we) {
                if (!this.gotFocus && this.focusizer != null) {
                    SwingRunnerSupport.invokeLater((Runnable)new FocusScheduler());
                }
            }

            @Override
            public void windowOpened(WindowEvent we) {
                if (DialogRequest.this.timeout > 0 && this.watchdog == null) {
                    this.watchdog = new LightweightTimer(2, (Runnable)new WatchdogAction());
                    this.watchdog.scheduleIn((long)DialogRequest.this.timeout * 1000L);
                }
            }

            @Override
            public void windowClosed(WindowEvent we) {
                if (this.watchdog != null) {
                    this.watchdog.cancel();
                    this.watchdog = null;
                }
            }

            private class FocusAction
            implements Runnable {
                private FocusAction() {
                }

                @Override
                public void run() {
                    if (MDWindowListener.this.gotFocus) {
                        return;
                    }
                    MDWindowListener.this.gotFocus = true;
                    if (DialogRequest.this.initFocus == null && DialogRequest.this.initFocusClass != null) {
                        DialogRequest.this.findInitFocusComponentByClass(DialogRequest.this.optionPane);
                    }
                    if (DialogRequest.this.initFocus != null) {
                        DialogRequest.this.initFocus.requestFocus();
                    } else {
                        DialogRequest.this.optionPane.selectInitialValue();
                    }
                }
            }

            private class FocusScheduler
            implements Runnable {
                private FocusScheduler() {
                }

                @Override
                public void run() {
                    if (MDWindowListener.this.focusizer != null) {
                        MDWindowListener.this.focusizer.scheduleIn(133L);
                    }
                }
            }

            private class WatchdogAction
            implements Runnable {
                private WatchdogAction() {
                }

                @Override
                public void run() {
                    JDialog d = DialogRequest.this.dlg;
                    MDWindowListener.this.watchdog = null;
                    if (d != null && d.isVisible()) {
                        d.setVisible(false);
                    }
                }
            }
        }
    }

    private static class ProcessorThread
    extends WorkerThread {
        private static QueuedRequest curRequest = null;

        private static synchronized QueuedRequest setCurrentRequest(QueuedRequest req) {
            QueuedRequest prev = curRequest;
            curRequest = req;
            return prev;
        }

        private static synchronized void restoreCurrentRequest(QueuedRequest req, QueuedRequest was) {
            curRequest = curRequest == was ? req : null;
        }

        static synchronized void reparentShowingDialog(Window win, Component newParent) {
            QueuedRequest cur = curRequest;
            if (UtilDebug.MODAL_DIALOG.show()) {
                LogSupport.message(ProcessorThread.class, (String)"reparentShowingDialog", (String)("Current request: " + cur));
            }
            if (cur != null) {
                cur.reparentDialog(win, newParent);
            }
        }

        public ProcessorThread() {
            super("ModalDialog Request Processor", 6);
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (!this.isInterrupted()) {
                QueuedRequest req = null;
                try {
                    req = queue.getNextEntry();
                    if (req == null) continue;
                    if (UtilDebug.MODAL_DIALOG.show()) {
                        LogSupport.message((Object)((Object)this), (String)"run", (String)("Processing queued request: " + req.hashCode()));
                    }
                    ProcessorThread.processRequest(req);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)((Object)this), (String)"run", (Throwable)t, (boolean)true, (String)req.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void processRequest(QueuedRequest req) {
            QueuedRequest savedRequest = ProcessorThread.setCurrentRequest(req);
            Debug.lockEnter(ProcessorThread.class, (String)"processRequest", (String)"Current Request", (Object)req);
            try {
                QueuedRequest queuedRequest = req;
                synchronized (queuedRequest) {
                    try {
                        if (!req.isDone()) {
                            req.execute();
                        }
                    }
                    catch (Throwable t) {
                        LogSupport.exception(ProcessorThread.class, (String)"processRequest", (Throwable)t, (boolean)true, (String)req.toString());
                    }
                    finally {
                        req.markDone();
                        req.notify();
                    }
                }
            }
            finally {
                Debug.lockLeave(ProcessorThread.class, (String)"processRequest", (String)"Current Request", (Object)req);
                ProcessorThread.restoreCurrentRequest(savedRequest, req);
            }
        }
    }

    private static abstract class QueuedRequest {
        protected volatile boolean done = false;
        protected Object[] optionSet = null;
        protected volatile Object result = null;
        protected final Thread requestor = Thread.currentThread();
        protected final String trace = Debug.getStackTrace((Throwable)new RuntimeException("Not Thrown"));
        protected Verifier verifier = null;
        protected Object verifierContext = null;

        protected QueuedRequest() {
        }

        void setOptions(Object[] options) {
            this.optionSet = options;
        }

        void setVerifier(Verifier vfr, Object context) {
            this.verifier = vfr;
            this.verifierContext = context;
        }

        public Object getResult() {
            return this.result;
        }

        public Thread getRequestor() {
            return this.requestor;
        }

        void markDone() {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public abstract void execute();

        void reparentDialog(Window win, Component newParent) {
        }

        public String toString() {
            return super.toString() + " on behalf of " + this.requestor + ":\n" + this.trace;
        }

        Object queueRequest() {
            return this.queueRequest(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object queueRequest(boolean waitFlag) {
            if (waitFlag && SwingUtilities.isEventDispatchThread()) {
                if (GUIDebug.DIALOG_THREAD.show()) {
                    LogSupport.message((Object)this, (String)"queueRequest", (String)"WARNING: queued from Swing thread w/wait");
                    Thread.dumpStack();
                }
                try {
                    ProcessorThread.processRequest(this);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"queueRequest", (Throwable)t, (boolean)true, (String)this.toString());
                }
                return this.result;
            }
            Debug.lockEnter((Object)this, (String)"queueRequest", (String)"New Request", (Object)this);
            try {
                QueuedRequest queuedRequest = this;
                synchronized (queuedRequest) {
                    queue.addLast(this);
                    while (waitFlag && !this.isDone()) {
                        try {
                            this.wait(1500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"queueRequest", (String)"New Request", (Object)this);
            }
            return waitFlag ? this.result : null;
        }

        int queueRequestIntResult() {
            this.queueRequest();
            if (this.result == null || this.result == UNINITIALIZED_VALUE) {
                return -1;
            }
            if (this.optionSet != null) {
                for (int ix = 0; ix < this.optionSet.length; ++ix) {
                    if (this.result != this.optionSet[ix]) continue;
                    return ix;
                }
                return -1;
            }
            if (this.result instanceof Number) {
                return ((Number)this.result).intValue();
            }
            try {
                int val = Integer.parseInt(this.result.toString().trim());
                return val;
            }
            catch (Throwable throwable) {
                LogSupport.message((Object)this, (String)"queueRequestIntResult", (String)("Invalid selection type: " + this.result.getClass() + " (" + this.result + ")"));
                return -1;
            }
        }
    }

    private static class RequestList
    extends LinkedList {
        private RequestList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLast(QueuedRequest req) {
            Debug.lockEnter((Object)this, (String)"addLast", (String)"Request Queue", (Object)this);
            try {
                RequestList requestList = this;
                synchronized (requestList) {
                    super.addLast(req);
                    if (this.size() == 1) {
                        this.notify();
                    }
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"addLast", (String)"Request Queue", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(QueuedRequest req) {
            Debug.lockEnter((Object)this, (String)"remove", (String)"Request Unqueue", (Object)this);
            try {
                RequestList requestList = this;
                synchronized (requestList) {
                    super.remove(req);
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"remove", (String)"Request Unqueue", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueuedRequest getNextEntry() {
            QueuedRequest result = null;
            Debug.lockEnter((Object)this, (String)"getFirst", (String)"Request Queue", (Object)this);
            try {
                RequestList requestList = this;
                synchronized (requestList) {
                    while (this.isEmpty()) {
                        try {
                            this.wait(1320L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    result = (QueuedRequest)super.getFirst();
                    super.remove(result);
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"getFirst", (String)"Request Queue", (Object)this);
            }
            return result;
        }
    }

    private static interface Verifier {
        public boolean verify(Object var1, Object var2);
    }
}

