/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.swing.DialogParentProvider;
import com.google.inject.Inject;
import java.awt.AWTEvent;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;

public class KeyBindingAdapter {
    private static final String PLATFORM = "PLATFORM";
    private String platformMask = "";
    private KeyStroke binding;
    private String keystroke;
    private String actionName;
    private AbstractAction action;
    private AWTEventListener windowEventListener;
    private DialogParentProvider parentProvider;

    public KeyBindingAdapter() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int mask = toolkit.getMenuShortcutKeyMask();
        if ((mask & 2) != 0) {
            this.platformMask = this.platformMask + "control";
        }
        if ((mask & 1) != 0) {
            if (this.platformMask.length() > 0) {
                this.platformMask = this.platformMask + " ";
            }
            this.platformMask = this.platformMask + "shift";
        }
        if ((mask & 4) != 0) {
            if (this.platformMask.length() > 0) {
                this.platformMask = this.platformMask + " ";
            }
            this.platformMask = this.platformMask + "meta";
        }
        if ((mask & 8) != 0) {
            if (this.platformMask.length() > 0) {
                this.platformMask = this.platformMask + " ";
            }
            this.platformMask = this.platformMask + "alt";
        }
    }

    @Inject
    public void initDialogParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    public void bind(String actionName, AbstractAction absAction, String keystroke) {
        this.doArgCheck(actionName, absAction, keystroke);
        this.actionName = actionName;
        this.bind(keystroke, absAction);
    }

    private void doArgCheck(Object ... args) {
        for (Object arg : args) {
            if (arg != null) continue;
            throw new RuntimeException("None of the passed in arguments can be null");
        }
    }

    private void bind(String keystroke, AbstractAction action) {
        this.keystroke = keystroke;
        this.action = action;
        this.bindKeystroke();
        this.setupWindowsListener();
    }

    private void setupWindowsListener() {
        this.windowEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyBindingAdapter.this.handleWindowEvent((WindowEvent)event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.windowEventListener, 64L);
    }

    private void bindKeystroke() {
        this.binding = this.generateKeyStroke(this.keystroke);
        Frame f = this.parentProvider.getDialogParent();
        if (f instanceof JFrame) {
            JFrame jf = (JFrame)f;
            this.setupBinding(jf.getRootPane(), this.action);
        }
    }

    private void handleWindowEvent(WindowEvent event) {
        Window w = event.getWindow();
        if (w != null && w instanceof RootPaneContainer) {
            if (event.getID() == 200) {
                this.setupBinding(((RootPaneContainer)((Object)w)).getRootPane(), this.action);
            } else if (event.getID() == 202) {
                this.removeBinding(((RootPaneContainer)((Object)w)).getRootPane());
            }
        }
    }

    private void setupBinding(JComponent comp, AbstractAction action) {
        comp.getInputMap(2).put(this.binding, this.actionName);
        comp.getActionMap().put(this.actionName, action);
    }

    private void removeBinding(JComponent comp) {
        comp.getInputMap(2).put(this.binding, null);
        comp.getActionMap().put(this.actionName, null);
    }

    private KeyStroke generateKeyStroke(String keystroke) {
        if (keystroke.contains("[") && keystroke.contains("]")) {
            String key = keystroke.substring(keystroke.indexOf("[") + 1, keystroke.indexOf("]"));
            keystroke = keystroke.replace("[" + key + "]", "");
            keystroke = keystroke.trim();
        }
        return KeyStroke.getKeyStroke(this.replacePlatformKey(keystroke));
    }

    private String replacePlatformKey(String keystroke) {
        return keystroke.replace(PLATFORM, this.platformMask);
    }
}

